/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.enderio.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.utils.MiscHelper;

public class SagMillingRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final int energy;
    public final BonusType bonusType;
    public final Object[] output;

    public SagMillingRecipeSerializer(ResourceLocation key, Object input, int energy, String bonusType, Object ... output) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.energy = energy;
        this.bonusType = Objects.requireNonNull(BonusType.valueOf(bonusType.toUpperCase(Locale.US)));
        this.output = output;
    }

    @Override
    public JsonElement get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.input));
        }
        ArrayList<OutputItem> outputs = new ArrayList<OutputItem>();
        int i = 0;
        while (i < this.output.length) {
            ItemStack stack;
            Object out = this.output[i];
            Integer count = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                count = (Integer)this.output[i];
                ++i;
            }
            Float chance = Float.valueOf(1.0f);
            if (i < this.output.length && this.output[i] instanceof Float) {
                chance = (Float)this.output[i];
                ++i;
            }
            if ((stack = MiscHelper.INSTANCE.getItemStack(out, count)).isEmpty()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
                continue;
            }
            outputs.add(new OutputItem(stack, chance.floatValue(), false));
        }
        SagMillingRecipe recipe = new SagMillingRecipe(ing, outputs, this.energy, this.bonusType);
        JsonObject json = MiscHelper.INSTANCE.serialize(SagMillingRecipe.CODEC, recipe).getAsJsonObject();
        json.addProperty("type", "enderio:sag_milling");
        return json;
    }

    public static enum BonusType implements StringRepresentable
    {
        NONE,
        MULTIPLY_OUTPUT,
        CHANCE_ONLY;

        public static final Codec<BonusType> CODEC;

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.US);
        }

        static {
            CODEC = StringRepresentable.fromEnum(BonusType::values);
        }
    }

    public record OutputItem(ItemStack output, float chance, boolean isOptional) {
        public static final Codec<OutputItem> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.CODEC.fieldOf("item").forGetter(OutputItem::output), (App)Codec.FLOAT.optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).forGetter(OutputItem::chance), (App)Codec.BOOL.optionalFieldOf("optional", (Object)false).forGetter(OutputItem::isOptional)).apply((Applicative)instance, OutputItem::new));
    }

    public record SagMillingRecipe(Ingredient input, List<OutputItem> outputs, int energy, BonusType bonusType) {
        public static final Codec<SagMillingRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("input").forGetter(SagMillingRecipe::input), (App)OutputItem.CODEC.listOf().fieldOf("outputs").forGetter(SagMillingRecipe::outputs), (App)Codec.INT.fieldOf("energy").forGetter(SagMillingRecipe::energy), (App)BonusType.CODEC.optionalFieldOf("bonus", (Object)BonusType.MULTIPLY_OUTPUT).forGetter(SagMillingRecipe::bonusType)).apply((Applicative)instance, SagMillingRecipe::new));
    }
}

