/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.energizedpower;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.energizedpower.EnergizedPowerHelper;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"energizedpower"})
public class EnergizedPowerModule
implements IModule {
    private static final double[] ORE_CHANCES = new double[]{1.0, 1.0, 0.25};
    private static final double[] ORE_CHANCES_ADVANCED = new double[]{1.0, 1.0, 0.5, 0.25};
    private static final double[] RAW_CHANCES = new double[]{1.0, 0.25};
    private static final double[] RAW_CHANCES_ADVANCED = new double[]{1.0, 0.5};
    private static final double[] RAW_BLOCK_CHANCES = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.5, 0.5, 0.25};
    private static final double[] RAW_BLOCK_CHANCES_ADVANCED = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 0.75, 0.5, 0.25, 0.25};
    private static final Set<String> BLACKLIST = new TreeSet<String>(List.of("copper", "gold", "iron", "netherite", "netherite_scrap", "tin"));

    @Override
    public String getName() {
        return "energizedpower";
    }

    @Override
    public Multimap<Integer, String> getModuleDependencies() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)0, (Object)"dusts");
        return builder.build();
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.of(MaterialType.INGOT, MaterialType.INGOT_LEGACY);
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return BLACKLIST;
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        EnergizedPowerHelper helper = EnergizedPowerHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        Set<ResourceLocation> itemTags = ((JAOPCAApi)api).getItemTags();
        for (IMaterial material : moduleData.getMaterials()) {
            ResourceLocation oreLocation = miscHelper.getTagLocation("ores", material.getName());
            ResourceLocation dustLocation = miscHelper.getTagLocation("dusts", material.getName());
            helper.registerPulverizerRecipe(miscHelper.getRecipeKey("energizedpower.ore_to_dust", material.getName()), oreLocation, dustLocation, ORE_CHANCES, ORE_CHANCES_ADVANCED);
            if (material.getType() != MaterialType.INGOT) continue;
            ResourceLocation rawMaterialLocation = miscHelper.getTagLocation("raw_materials", material.getName());
            ResourceLocation rawStorageBlockLocation = miscHelper.getTagLocation("storage_blocks/raw", material.getName(), "_");
            helper.registerPulverizerRecipe(miscHelper.getRecipeKey("energizedpower.raw_material_to_dust", material.getName()), rawMaterialLocation, dustLocation, RAW_CHANCES, RAW_CHANCES_ADVANCED);
            if (!itemTags.contains(rawStorageBlockLocation)) continue;
            helper.registerPulverizerRecipe(miscHelper.getRecipeKey("energizedpower.raw_storage_block_to_dust", material.getName()), rawStorageBlockLocation, dustLocation, RAW_BLOCK_CHANCES, RAW_BLOCK_CHANCES_ADVANCED);
        }
    }
}

