/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.energizedpower.recipes;

import com.google.gson.JsonElement;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import me.jddev0.ep.recipe.AlloyFurnaceRecipe;
import me.jddev0.ep.recipe.IngredientWithCount;
import me.jddev0.ep.recipe.OutputItemStackWithPercentages;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.utils.MiscHelper;

public class AlloyFurnaceRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object[] input;
    public final Object output;
    public final int outputCount;
    public final Object secondOutput;
    public final double[] secondChances;
    public final int time;

    public AlloyFurnaceRecipeSerializer(ResourceLocation key, Object[] input, Object output, int outputCount, int time) {
        this(key, input, output, outputCount, ItemStack.EMPTY, DoubleArrays.EMPTY_ARRAY, time);
    }

    public AlloyFurnaceRecipeSerializer(ResourceLocation key, Object[] input, Object output, int outputCount, Object secondOutput, double[] secondChances, int time) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.output = output;
        this.outputCount = outputCount;
        this.secondOutput = secondOutput;
        this.secondChances = secondChances;
        this.time = time;
    }

    @Override
    public JsonElement get() {
        ArrayList<IngredientWithCount> inputs = new ArrayList<IngredientWithCount>();
        int i = 0;
        while (i < this.input.length) {
            Ingredient ing;
            Object in = this.input[i];
            Integer count = 1;
            if (++i < this.input.length && this.input[i] instanceof Integer) {
                count = (Integer)this.input[i];
                ++i;
            }
            if ((ing = MiscHelper.INSTANCE.getIngredient(in)) == null) {
                throw new IllegalArgumentException("Empty ingredient in recipe " + String.valueOf(this.key) + ": " + String.valueOf(in));
            }
            inputs.add(new IngredientWithCount(ing, count.intValue()));
        }
        if (inputs.isEmpty()) {
            throw new IllegalArgumentException("Empty ingredients in recipe " + String.valueOf(this.key) + ": " + Arrays.deepToString(this.input));
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        ItemStack secondStack = MiscHelper.INSTANCE.getItemStack(this.secondOutput, 1);
        if (stack.isEmpty() && (secondStack.isEmpty() || this.secondChances.length == 0)) {
            throw new IllegalArgumentException("Empty outputs in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.output) + ", " + String.valueOf(this.secondOutput));
        }
        AlloyFurnaceRecipe recipe = new AlloyFurnaceRecipe(stack, new OutputItemStackWithPercentages(secondStack, this.secondChances), (IngredientWithCount[])inputs.toArray(IngredientWithCount[]::new), this.time);
        return MiscHelper.INSTANCE.serializeRecipe((Recipe<?>)recipe);
    }
}

