/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.immersiveengineering;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.immersiveengineering.ImmersiveEngineeringHelper;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"immersiveengineering"})
public class ImmersiveEngineeringModule
implements IModule {
    private static final Set<String> BLACKLIST = new TreeSet<String>(List.of("aluminum", "aluminium", "ardite", "cobalt", "copper", "gold", "iron", "lead", "netherite", "netherite_scrap", "nickel", "osmium", "platinum", "silver", "tin", "tungsten", "uranium", "zinc"));

    @Override
    public String getName() {
        return "immersiveengineering";
    }

    @Override
    public Multimap<Integer, String> getModuleDependencies() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)0, (Object)"dusts");
        builder.put((Object)1, (Object)"dusts");
        return builder.build();
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.of(MaterialType.INGOT, MaterialType.INGOT_LEGACY);
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return BLACKLIST;
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        ImmersiveEngineeringHelper helper = ImmersiveEngineeringHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        Set<ResourceLocation> itemTags = ((JAOPCAApi)api).getItemTags();
        Item hammer = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"immersiveengineering:hammer"));
        ResourceLocation slagLocation = ResourceLocation.parse((String)"forge:slag");
        for (IMaterial material : moduleData.getMaterials()) {
            ResourceLocation oreLocation = miscHelper.getTagLocation("ores", material.getName());
            ResourceLocation dustLocation = miscHelper.getTagLocation("dusts", material.getName());
            ResourceLocation extraDustLocation = miscHelper.getTagLocation("dusts", material.getExtra(1).getName());
            ResourceLocation materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
            ((JAOPCAApi)api).registerShapelessRecipe(miscHelper.getRecipeKey("immersiveengineering.ore_to_dust_hammer", material.getName()), dustLocation, 1, oreLocation, hammer);
            if (material.hasExtra(1)) {
                helper.registerCrusherRecipe(miscHelper.getRecipeKey("immersiveengineering.ore_to_dust_crusher", material.getName()), oreLocation, new Object[]{dustLocation, 2, extraDustLocation, 1, Float.valueOf(0.1f)}, 6000);
            } else {
                helper.registerCrusherRecipe(miscHelper.getRecipeKey("immersiveengineering.ore_to_dust_crusher", material.getName()), oreLocation, new Object[]{dustLocation, 2}, 6000);
            }
            helper.registerArcFurnaceRecipe(miscHelper.getRecipeKey("immersiveengineering.ore_to_ingot", material.getName()), new Object[]{oreLocation, 1}, slagLocation, 1, new Object[]{materialLocation, 2}, 200, 102400);
            if (material.getType() != MaterialType.INGOT) continue;
            ResourceLocation rawMaterialLocation = miscHelper.getTagLocation("raw_materials", material.getName());
            ResourceLocation rawStorageBlockLocation = miscHelper.getTagLocation("storage_blocks/raw", material.getName(), "_");
            ((JAOPCAApi)api).registerShapelessRecipe(miscHelper.getRecipeKey("immersiveengineering.raw_material_to_dust_hammer", material.getName()), dustLocation, 1, rawMaterialLocation, hammer);
            helper.registerCrusherRecipe(miscHelper.getRecipeKey("immersiveengineering.raw_material_to_dust_crusher", material.getName()), rawMaterialLocation, new Object[]{dustLocation, 1, dustLocation, 1, Float.valueOf(0.33333334f)}, 6000);
            helper.registerArcFurnaceRecipe(miscHelper.getRecipeKey("immersiveengineering.raw_material_to_ingot", material.getName()), new Object[]{rawMaterialLocation, 1}, new Object[]{materialLocation, 1, materialLocation, 1, Float.valueOf(0.5f)}, 100, 25600);
            if (!itemTags.contains(rawStorageBlockLocation)) continue;
            helper.registerCrusherRecipe(miscHelper.getRecipeKey("immersiveengineering.raw_storage_block_to_dust", material.getName()), rawStorageBlockLocation, new Object[]{dustLocation, 12}, 54000);
            helper.registerArcFurnaceRecipe(miscHelper.getRecipeKey("immersiveengineering.raw_storage_block_to_ingot", material.getName()), new Object[]{rawStorageBlockLocation, 1}, new Object[]{materialLocation, 13, materialLocation, 1, Float.valueOf(0.5f)}, 900, 230400);
        }
    }
}

