/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.kubejs.utils;

import java.util.List;
import java.util.TreeMap;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.compat.kubejs.utils.Form;
import thelm.jaopca.compat.kubejs.utils.MaterialForm;
import thelm.jaopca.utils.MiscHelper;

public class Material {
    private static final TreeMap<IMaterial, Material> MATERIAL_WRAPPERS = new TreeMap();
    private final IMaterial material;

    public static Material getMaterialWrapper(IMaterial material) {
        return MATERIAL_WRAPPERS.computeIfAbsent(material, Material::new);
    }

    private Material(IMaterial material) {
        this.material = material;
    }

    public IMaterial getInternal() {
        return this.material;
    }

    public String getName() {
        return this.material.getName();
    }

    public String getType() {
        return this.material.getType().getName();
    }

    public List<String> getAlternativeNames() {
        return this.material.getAlternativeNames().stream().toList();
    }

    public Material getExtra(int index) {
        return new Material(this.material.getExtra(index));
    }

    public boolean hasExtra(int index) {
        return this.material.hasExtra(index);
    }

    public boolean isSmallStorageBlock() {
        return this.material.isSmallStorageBlock();
    }

    public String getTag(String prefix) {
        return this.getTag(prefix, "/");
    }

    public String getTag(String prefix, String tagSeperator) {
        return MiscHelper.INSTANCE.getTagLocation(prefix, this.material.getName(), tagSeperator).toString();
    }

    public ItemStack getItemStack(String prefix, int count) {
        MiscHelper helper = MiscHelper.INSTANCE;
        return helper.getItemStack(helper.getTagLocation(prefix, this.material.getName()), count);
    }

    public ItemStack getItemStack(String prefix) {
        return this.getItemStack(prefix, 1);
    }

    public FluidStack getFluidStack(String prefix, int count) {
        MiscHelper helper = MiscHelper.INSTANCE;
        return helper.getFluidStack(helper.getTagLocation(prefix, this.material.getName()), count);
    }

    public MaterialForm getMaterialForm(Form form) {
        if (!form.containsMaterial(this)) {
            return null;
        }
        return MaterialForm.getMaterialFormWrapper(form.getInternal(), this.material);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Material) {
            Material other = (Material)obj;
            return this.material == other.material;
        }
        return false;
    }

    public int hashCode() {
        return this.material.hashCode() + 7;
    }
}

