/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.mekanism.chemicals;

import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalBuilder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.compat.mekanism.api.chemicals.IChemicalFormSettings;
import thelm.jaopca.compat.mekanism.api.chemicals.IMaterialFormChemical;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

public class JAOPCAChemical
extends Chemical
implements IMaterialFormChemical {
    private final IForm form;
    private final IMaterial material;
    protected final IChemicalFormSettings settings;

    public JAOPCAChemical(IForm form, IMaterial material, IChemicalFormSettings settings) {
        super(ChemicalBuilder.builder((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"jaopca", (String)("chemical/" + material.getModelType() + "/" + form.getName()))));
        this.form = form;
        this.material = material;
        this.settings = settings;
    }

    @Override
    public IForm getForm() {
        return this.form;
    }

    @Override
    public IMaterial getMaterial() {
        return this.material;
    }

    public int getTint() {
        return 0xFFFFFF & this.material.getColor();
    }

    public ResourceLocation getIcon() {
        if (MiscHelper.INSTANCE.hasResource(this.getRegistryName().withPath("textures/chemical/" + this.getRegistryName().getPath() + ".png"))) {
            return this.getRegistryName().withPath("chemical/" + this.getRegistryName().getPath());
        }
        return super.getIcon();
    }

    public Component getTextComponent() {
        return ApiImpl.INSTANCE.currentLocalizer().localizeMaterialForm("chemical.jaopca." + this.form.getName(), this.material, this.getTranslationKey());
    }

    public ResourceLocation getRegistryName() {
        return MekanismAPI.CHEMICAL_REGISTRY.getKey((Object)this);
    }
}

