/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.oritech.recipes;

import com.google.gson.JsonElement;
import dev.architectury.hooks.fluid.forge.FluidStackHooksForge;
import java.util.List;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.util.FluidIngredient;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.compat.oritech.OritechHelper;
import thelm.jaopca.utils.MiscHelper;

public class CentrifugeFluidRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final Object fluidInput;
    public final int fluidInputAmount;
    public final Object output;
    public final int outputCount;
    public final Object secondOutput;
    public final int secondOutputCount;
    public final Object fluidOutput;
    public final int fluidOutputAmount;
    public final int time;

    public CentrifugeFluidRecipeSerializer(ResourceLocation key, Object input, Object fluidInput, int fluidInputAmount, Object output, int outputCount, Object fluidOutput, int fluidOutputAmount, int time) {
        this(key, input, fluidInput, fluidInputAmount, output, outputCount, ItemStack.EMPTY, 0, fluidOutput, fluidOutputAmount, time);
    }

    public CentrifugeFluidRecipeSerializer(ResourceLocation key, Object input, Object fluidInput, int fluidInputAmount, Object output, int outputCount, Object secondOutput, int secondOutputCount, Object fluidOutput, int fluidOutputAmount, int time) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.fluidInput = fluidInput;
        this.fluidInputAmount = fluidInputAmount;
        this.output = output;
        this.outputCount = outputCount;
        this.secondOutput = secondOutput;
        this.secondOutputCount = secondOutputCount;
        this.fluidOutput = fluidOutput;
        this.fluidOutputAmount = fluidOutputAmount;
        this.time = time;
    }

    @Override
    public JsonElement get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        FluidIngredient fluidIng = OritechHelper.INSTANCE.getFluidIngredient(this.fluidInput, this.fluidInputAmount);
        if (ing == null && fluidIng.isEmpty()) {
            throw new IllegalArgumentException("Empty ingredients in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.input) + ", " + String.valueOf(this.fluidInput));
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        ItemStack secondStack = MiscHelper.INSTANCE.getItemStack(this.secondOutput, this.secondOutputCount);
        FluidStack fluidStack = MiscHelper.INSTANCE.getFluidStack(this.fluidOutput, this.fluidOutputAmount);
        if (stack.isEmpty() && secondStack.isEmpty() && fluidStack.isEmpty()) {
            throw new IllegalArgumentException("Empty outputs in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.output) + ", " + String.valueOf(this.secondOutput) + ", " + String.valueOf(this.fluidOutput));
        }
        List<Object> results = secondStack.isEmpty() ? (stack.isEmpty() ? List.of() : List.of(stack)) : List.of(stack, secondStack);
        OritechRecipe recipe = new OritechRecipe(this.time, List.of(ing), results, RecipeContent.CENTRIFUGE_FLUID, fluidIng, FluidStackHooksForge.fromForge((FluidStack)fluidStack));
        return MiscHelper.INSTANCE.serializeRecipe((Recipe<?>)recipe);
    }
}

