/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.railcraft;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.railcraft.RailcraftHelper;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"railcraft"})
public class RailcraftNonIngotModule
implements IModule {
    private static final Set<String> BLACKLIST = new TreeSet<String>(List.of("coal", "diamond", "emerald", "firestone", "lapis", "quartz", "redstone", "salt", "sulfur"));

    @Override
    public String getName() {
        return "railcraft_non_ingot";
    }

    @Override
    public Multimap<Integer, String> getModuleDependencies() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)1, (Object)"dusts");
        return builder.build();
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.of(MaterialType.GEM, MaterialType.CRYSTAL, MaterialType.DUST);
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        RailcraftHelper helper = RailcraftHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        for (IMaterial material : moduleData.getMaterials()) {
            int mainOutputCount;
            if (BLACKLIST.contains(material.getName())) continue;
            ResourceLocation oreLocation = miscHelper.getTagLocation("ores", material.getName());
            ResourceLocation extraDustLocation = miscHelper.getTagLocation("dusts", material.getExtra(1).getName());
            ResourceLocation materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
            int n = mainOutputCount = material.getType() != MaterialType.DUST ? 1 : 3;
            if (material.hasExtra(1)) {
                helper.registerCrusherRecipe(miscHelper.getRecipeKey("railcraft.ore_to_material", material.getName()), oreLocation, 200, materialLocation, mainOutputCount, Float.valueOf(1.0f), materialLocation, 1, Float.valueOf(0.85f), materialLocation, 1, Float.valueOf(0.25f), extraDustLocation, 1, Float.valueOf(0.1f));
                continue;
            }
            helper.registerCrusherRecipe(miscHelper.getRecipeKey("railcraft.ore_to_material", material.getName()), oreLocation, 200, materialLocation, mainOutputCount, Float.valueOf(1.0f), materialLocation, 1, Float.valueOf(0.85f), materialLocation, 1, Float.valueOf(0.25f));
        }
    }
}

