/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.railcraft.recipes;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import mods.railcraft.world.item.crafting.RollingRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.utils.MiscHelper;

public class RollingRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object output;
    public final int outputCount;
    public final int time;
    public final Object[] input;

    public RollingRecipeSerializer(ResourceLocation key, Object output, int outputCount, int time, Object ... input) {
        this.key = Objects.requireNonNull(key);
        this.output = output;
        this.outputCount = outputCount;
        this.time = time;
        this.input = Objects.requireNonNull(input);
    }

    @Override
    public JsonElement get() {
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Empty output in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.output));
        }
        ArrayList<String> pattern = new ArrayList<String>();
        int idx = 0;
        if (this.input[idx] instanceof String[]) {
            String[] parts;
            for (String s : parts = (String[])this.input[idx++]) {
                if (!pattern.isEmpty() && s.length() != ((String)pattern.get(0)).length()) {
                    throw new IllegalArgumentException("Invalid pattern in recipe " + String.valueOf(this.key) + "Pattern must be the same width on every line");
                }
                pattern.add(s);
            }
        } else {
            while (this.input[idx] instanceof String) {
                String s = (String)this.input[idx++];
                pattern.add(s);
            }
        }
        HashMap<Character, Ingredient> keyMap = new HashMap<Character, Ingredient>();
        while (idx < this.input.length) {
            Character chr = (Character)this.input[idx];
            Object in = this.input[idx + 1];
            Ingredient ing = MiscHelper.INSTANCE.getIngredient(in);
            if (keyMap.containsKey(chr)) {
                throw new IllegalArgumentException("Invalid key entry in recipe " + String.valueOf(this.key) + ": Symbol '" + chr + "' is defined twice");
            }
            if (' ' == chr.charValue()) {
                throw new IllegalArgumentException("Invalid key entry in recipe " + String.valueOf(this.key) + ": Symbol ' ' is reserved");
            }
            if (ing == null) {
                throw new IllegalArgumentException("Empty ingredient in recipe " + String.valueOf(this.key) + ": " + String.valueOf(in));
            }
            keyMap.put(chr, ing);
            idx += 2;
        }
        if (pattern.isEmpty()) {
            throw new IllegalArgumentException("No pattern is defined for shaped recipe " + String.valueOf(this.key));
        }
        HashSet set = new HashSet(keyMap.keySet());
        for (String str : pattern) {
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                if (!keyMap.containsKey(Character.valueOf(c)) && c != ' ') {
                    throw new IllegalArgumentException("Pattern in recipe " + String.valueOf(this.key) + " uses undefined symbol '" + c + "'");
                }
                set.remove(Character.valueOf(c));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalArgumentException("Ingredients are defined but not used in pattern for recipe " + String.valueOf(this.key));
        }
        RollingRecipe recipe = new RollingRecipe(ShapedRecipePattern.of(keyMap, pattern), stack, this.time);
        return MiscHelper.INSTANCE.serializeRecipe((Recipe<?>)recipe);
    }
}

