/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.techreborn;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import org.apache.commons.lang3.ArrayUtils;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.techreborn.TechRebornHelper;
import thelm.jaopca.compat.techreborn.TechRebornIndustrialIngotModule;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"techreborn"})
public class TechRebornIndustrialCrystalModule
implements IModule {
    private static Set<String> configWaterBlacklist = new TreeSet<String>();
    private static Set<String> configMercuryBlacklist = new TreeSet<String>();

    @Override
    public String getName() {
        return "techreborn_industrial_crystal";
    }

    @Override
    public Multimap<Integer, String> getModuleDependencies() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)0, (Object)"small_dusts");
        builder.put((Object)1, (Object)"small_dusts");
        return builder.build();
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.of(MaterialType.GEM, MaterialType.CRYSTAL);
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return TechRebornIndustrialIngotModule.BLACKLIST;
    }

    @Override
    public void defineModuleConfig(IModuleData moduleData, IDynamicSpecConfig config) {
        MiscHelper helper = MiscHelper.INSTANCE;
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.waterMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have water industrial grinder recipes added."), configWaterBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.mercuryMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have mercury industrial grinder recipes added."), configMercuryBlacklist);
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        TechRebornHelper helper = TechRebornHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        Fluid mercury = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)"techreborn:mercury"));
        for (IMaterial material : moduleData.getMaterials()) {
            Object[] output;
            ResourceLocation oreLocation = miscHelper.getTagLocation("ores", material.getName());
            ResourceLocation materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
            ResourceLocation smallDustLocation = miscHelper.getTagLocation("small_dusts", material.getName());
            ResourceLocation extraSmallDustLocation = miscHelper.getTagLocation("small_dusts", material.getExtra(1).getName());
            if (!configWaterBlacklist.contains(material.getName())) {
                output = new Object[]{materialLocation, 1, smallDustLocation, 6};
                if (material.hasExtra(1)) {
                    output = ArrayUtils.addAll((Object[])output, (Object[])new Object[]{extraSmallDustLocation, 2});
                }
                helper.registerIndustrialGrinderRecipe(miscHelper.getRecipeKey("techreborn.ore_to_material_water", material.getName()), oreLocation, 1, Fluids.WATER, 81000L, 64, 100, output);
            }
            if (configMercuryBlacklist.contains(material.getName())) continue;
            output = new Object[]{materialLocation, 2, smallDustLocation, 3};
            if (material.hasExtra(1)) {
                output = ArrayUtils.addAll((Object[])output, (Object[])new Object[]{smallDustLocation, 2});
            }
            helper.registerIndustrialGrinderRecipe(miscHelper.getRecipeKey("techreborn.ore_to_material_mercury", material.getName()), oreLocation, 1, mercury, 81000L, 64, 100, output);
        }
    }
}

