/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.techreborn;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import org.apache.commons.lang3.ArrayUtils;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.techreborn.TechRebornHelper;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"techreborn"})
public class TechRebornIndustrialIngotModule
implements IModule {
    static final Set<String> BLACKLIST = new TreeSet<String>(Arrays.asList("bauxite", "certus_quartz", "cinnabar", "coal", "copper", "diamond", "emerald", "galena", "gold", "iron", "iridium", "lapis", "lead", "netherite", "netherite_scrap", "peridot", "pyrite", "quartz", "redstone", "ruby", "sapphire", "sheldonite", "silver", "sodalite", "sphalerite", "tin", "tungsten"));
    private static Set<String> configWaterBlacklist = new TreeSet<String>();
    private static Set<String> configMercuryBlacklist = new TreeSet<String>();
    private static Set<String> configSodiumPersulfateBlacklist = new TreeSet<String>();

    @Override
    public String getName() {
        return "techreborn_industrial_ingot";
    }

    @Override
    public Multimap<Integer, String> getModuleDependencies() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)1, (Object)"nuggets");
        builder.put((Object)1, (Object)"small_dusts");
        builder.put((Object)1, (Object)"dusts");
        builder.put((Object)2, (Object)"dusts");
        return builder.build();
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.of(MaterialType.INGOT);
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return BLACKLIST;
    }

    @Override
    public void defineModuleConfig(IModuleData moduleData, IDynamicSpecConfig config) {
        MiscHelper helper = MiscHelper.INSTANCE;
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.waterMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have water industrial grinder recipes added."), configWaterBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.mercuryMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have mercury industrial grinder recipes added."), configMercuryBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.sodiumPersulfateMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have sodium persulfate\t industrial grinder recipes added."), configSodiumPersulfateBlacklist);
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        TechRebornHelper helper = TechRebornHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        Fluid mercury = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)"techreborn:mercury"));
        Fluid sodiumPersulfate = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)"techreborn:sodium_persulfate"));
        for (IMaterial material : moduleData.getMaterials()) {
            int extraCount;
            ResourceLocation extraLocation;
            IMaterial extraMaterial;
            Object[] output;
            ResourceLocation oreLocation = miscHelper.getTagLocation("ores", material.getName());
            ResourceLocation rawMaterialLocation = miscHelper.getTagLocation("raw_materials", material.getName());
            if (!configWaterBlacklist.contains(material.getName())) {
                output = new Object[]{rawMaterialLocation, 2};
                if (material.hasExtra(1)) {
                    extraMaterial = material.getExtra(1);
                    if (extraMaterial.getType().isIngot()) {
                        extraLocation = miscHelper.getTagLocation("nuggets", extraMaterial.getName());
                        extraCount = 3;
                    } else {
                        extraLocation = miscHelper.getTagLocation("small_dusts", extraMaterial.getName());
                        extraCount = 2;
                    }
                    output = ArrayUtils.addAll((Object[])output, (Object[])new Object[]{extraLocation, extraCount});
                }
                if (material.hasExtra(2)) {
                    extraMaterial = material.getExtra(2);
                    if (extraMaterial.getType().isIngot()) {
                        extraLocation = miscHelper.getTagLocation("nuggets", extraMaterial.getName());
                        extraCount = 3;
                    } else {
                        extraLocation = miscHelper.getTagLocation("small_dusts", extraMaterial.getName());
                        extraCount = 2;
                    }
                    output = ArrayUtils.addAll((Object[])output, (Object[])new Object[]{extraLocation, extraCount});
                }
                helper.registerIndustrialGrinderRecipe(miscHelper.getRecipeKey("techreborn.ore_to_raw_material_water", material.getName()), oreLocation, 1, Fluids.WATER, 81000L, 64, 100, output);
            }
            if (!configMercuryBlacklist.contains(material.getName())) {
                output = new Object[]{rawMaterialLocation, 3};
                if (material.hasExtra(1)) {
                    extraMaterial = material.getExtra(1);
                    if (extraMaterial.getType().isIngot()) {
                        extraLocation = miscHelper.getTagLocation("nuggets", extraMaterial.getName());
                        extraCount = 3;
                    } else {
                        extraLocation = miscHelper.getTagLocation("small_dusts", extraMaterial.getName());
                        extraCount = 2;
                    }
                    output = ArrayUtils.addAll((Object[])output, (Object[])new Object[]{extraLocation, extraCount});
                }
                if (material.hasExtra(2)) {
                    extraMaterial = material.getExtra(2);
                    if (extraMaterial.getType().isIngot()) {
                        extraLocation = miscHelper.getTagLocation("nuggets", extraMaterial.getName());
                        extraCount = 3;
                    } else {
                        extraLocation = miscHelper.getTagLocation("small_dusts", extraMaterial.getName());
                        extraCount = 2;
                    }
                    output = ArrayUtils.addAll((Object[])output, (Object[])new Object[]{extraLocation, extraCount});
                }
                helper.registerIndustrialGrinderRecipe(miscHelper.getRecipeKey("techreborn.ore_to_raw_material_mercury", material.getName()), oreLocation, 1, mercury, 81000L, 64, 100, output);
            }
            if (configSodiumPersulfateBlacklist.contains(material.getName()) || !material.hasExtra(1)) continue;
            IMaterial extraMaterial2 = material.getExtra(1);
            ResourceLocation extraLocation2 = extraMaterial2.getType() == MaterialType.INGOT ? miscHelper.getTagLocation("raw_materials", extraMaterial2.getName()) : miscHelper.getTagLocation("dusts", extraMaterial2.getName());
            Object[] output2 = new Object[]{rawMaterialLocation, 2, extraLocation2, 1};
            if (material.hasExtra(2)) {
                extraLocation2 = extraMaterial2.getType() == MaterialType.INGOT ? miscHelper.getTagLocation("raw_materials", extraMaterial2.getName()) : miscHelper.getTagLocation("dusts", extraMaterial2.getName());
                output2 = ArrayUtils.addAll((Object[])output2, (Object[])new Object[]{extraLocation2, 1});
            }
            helper.registerIndustrialGrinderRecipe(miscHelper.getRecipeKey("techreborn.ore_to_raw_material_sodium_persulfate", material.getName()), oreLocation, 1, sodiumPersulfate, 81000L, 64, 100, output2);
        }
    }
}

