/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.techreborn.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.compat.techreborn.recipes.RebornRecipe;
import thelm.jaopca.utils.MiscHelper;

public class GrinderRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final int inputCount;
    public final Object output;
    public final int outputCount;
    public final int power;
    public final int time;

    public GrinderRecipeSerializer(ResourceLocation key, Object input, int inputCount, Object output, int outputCount, int power, int time) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.inputCount = inputCount;
        this.output = output;
        this.outputCount = outputCount;
        this.power = power;
        this.time = time;
    }

    @Override
    public JsonElement get() {
        SizedIngredient ing = MiscHelper.INSTANCE.getSizedIngredient(this.input, this.inputCount);
        if (ing == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.input));
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Empty output in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.output));
        }
        RebornRecipe recipe = new RebornRecipe(List.of(ing), List.of(stack), this.power, this.time);
        JsonObject json = MiscHelper.INSTANCE.serialize(RebornRecipe.CODEC, recipe).getAsJsonObject();
        json.addProperty("type", "techreborn:grinder");
        return json;
    }
}

