/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.techreborn.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.sinytra.fabric.transfer_api.compat.NeoCompatUtil;
import reborncore.common.fluid.FluidValue;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.compat.techreborn.recipes.FluidInstance;
import thelm.jaopca.utils.MiscHelper;

public class IndustrialGrinderRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object itemInput;
    public final int itemInputCount;
    public final Object fluidInput;
    public final long fluidInputAmount;
    public final int power;
    public final int time;
    public final Object[] output;

    public IndustrialGrinderRecipeSerializer(ResourceLocation key, Object itemInput, int itemInputCount, Object fluidInput, long fluidInputAmount, int power, int time, Object ... output) {
        this.key = Objects.requireNonNull(key);
        this.itemInput = itemInput;
        this.itemInputCount = itemInputCount;
        this.fluidInput = fluidInput;
        this.fluidInputAmount = fluidInputAmount;
        this.power = power;
        this.time = time;
        this.output = Objects.requireNonNull(output);
    }

    @Override
    public JsonElement get() {
        SizedIngredient ing = MiscHelper.INSTANCE.getSizedIngredient(this.itemInput, this.itemInputCount);
        FluidStack fluidIng = MiscHelper.INSTANCE.getFluidStack(this.fluidInput, 1000);
        if (ing == null && fluidIng.isEmpty()) {
            throw new IllegalArgumentException("Empty ingredients in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.itemInput) + ", " + String.valueOf(this.fluidInput));
        }
        FluidInstance fluidInst = new FluidInstance(NeoCompatUtil.toFluidStorageView((FluidStack)fluidIng), new FluidValue(this.fluidInputAmount));
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        int i = 0;
        while (i < this.output.length) {
            ItemStack is;
            Object out = this.output[i];
            Integer count = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                count = (Integer)this.output[i];
                ++i;
            }
            if ((is = MiscHelper.INSTANCE.getItemStack(out, count)) == null) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
                continue;
            }
            outputs.add(is);
        }
        if (outputs.isEmpty()) {
            throw new IllegalArgumentException("Empty outputs in recipe " + String.valueOf(this.key) + ": " + Arrays.deepToString(this.output));
        }
        IndustrialGrinderRecipe recipe = new IndustrialGrinderRecipe(List.of(ing), outputs, this.power, this.time, fluidInst);
        JsonObject json = MiscHelper.INSTANCE.serialize(IndustrialGrinderRecipe.CODEC, recipe).getAsJsonObject();
        json.addProperty("type", "techreborn:industrial_grinder");
        return json;
    }

    public record IndustrialGrinderRecipe(List<SizedIngredient> ingredients, List<ItemStack> outputs, int power, int time, FluidInstance fluid) {
        public static final Codec<IndustrialGrinderRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SizedIngredient.FLAT_CODEC.listOf().fieldOf("ingredients").forGetter(IndustrialGrinderRecipe::ingredients), (App)ItemStack.CODEC.listOf().fieldOf("outputs").forGetter(IndustrialGrinderRecipe::outputs), (App)Codec.INT.fieldOf("power").forGetter(IndustrialGrinderRecipe::power), (App)Codec.INT.fieldOf("time").forGetter(IndustrialGrinderRecipe::time), (App)FluidInstance.CODEC.fieldOf("fluid").forGetter(IndustrialGrinderRecipe::fluid)).apply((Applicative)instance, IndustrialGrinderRecipe::new));
    }
}

