/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.theurgy;

import com.klikli_dev.theurgy.content.item.derivative.AlchemicalDerivativeTier;
import com.klikli_dev.theurgy.content.item.sulfur.AlchemicalSulfurType;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.forms.IFormRequest;
import thelm.jaopca.api.functions.MaterialMappedFunction;
import thelm.jaopca.api.items.IItemInfo;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.theurgy.TheurgyHelper;
import thelm.jaopca.compat.theurgy.items.JAOPCAAlchemicalSulfurItem;
import thelm.jaopca.items.ItemFormType;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"theurgy@[1.34,)"})
public class TheurgyModule
implements IModule {
    private static final Set<String> BLACKLIST = new TreeSet<String>(List.of("allthemodium", "amethyst", "apatite", "azure_silver", "cinnabar", "coal", "copper", "crimson_iron", "diamond", "emerald", "fluorite", "gold", "iridium", "iron", "lapis", "lead", "netherite", "netherite_scrap", "nickel", "osmium", "peridot", "platinum", "prismarine", "quartz", "redstone", "ruby", "sal_ammoniac", "sapphire", "silver", "sulfur", "tin", "unobtainium", "uranium", "vibranium", "zinc"));
    public static final Function<IMaterial, AlchemicalDerivativeTier> TIER_FUNCTION = MaterialMappedFunction.of(AlchemicalDerivativeTier.class, AlchemicalDerivativeTier.COMMON, "theurgy.tier", "The alchemical sulfur tier of this material.");
    private static boolean addTierTags = false;
    private final IForm alchemicalSulfurForm = ApiImpl.INSTANCE.newForm(this, "theurgy_alchemical_sulfurs", ItemFormType.INSTANCE).setMaterialTypes(MaterialType.ORE).setSecondaryName("theurgy:alchemical_sulfurs").setDefaultMaterialBlacklist(BLACKLIST).setSettings(ItemFormType.INSTANCE.getNewSettings().setItemCreator(JAOPCAAlchemicalSulfurItem::new));

    @Override
    public String getName() {
        return "theurgy";
    }

    @Override
    public List<IFormRequest> getFormRequests() {
        return List.of(this.alchemicalSulfurForm.toRequest());
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.copyOf(Arrays.asList(MaterialType.ORE));
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return BLACKLIST;
    }

    @Override
    public void defineModuleConfig(IModuleData moduleData, IDynamicSpecConfig config) {
        addTierTags = config.getDefinedBoolean("tags.addTierTags", addTierTags, "Should the module add tier tags for alchemical sulfurs.");
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        TheurgyHelper helper = TheurgyHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        ItemFormType itemFormType = ItemFormType.INSTANCE;
        Fluid salAmmoniac = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)"theurgy:sal_ammoniac"));
        Item mercuryShard = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"theurgy:mercury_shard"));
        Item alchemicalSaltMineral = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)"theurgy:alchemical_salt_mineral"));
        for (IMaterial material : this.alchemicalSulfurForm.getMaterials()) {
            IItemInfo alchemicalSulfurInfo = itemFormType.getMaterialFormInfo(this.alchemicalSulfurForm, material);
            ResourceLocation alchemicalSulfurLocation = miscHelper.getTagLocation("theurgy:alchemical_sulfurs", material.getName());
            ResourceLocation oreLocation = miscHelper.getTagLocation("ores", material.getName());
            ResourceLocation materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
            int oreCount = switch (material.getType()) {
                case MaterialType.INGOT, MaterialType.INGOT_LEGACY -> 3;
                case MaterialType.GEM, MaterialType.CRYSTAL -> 4;
                default -> 5;
            };
            helper.registerLiquefactionRecipe(miscHelper.getRecipeKey("theurgy.ore_to_alchemical_sulfur", material.getName()), oreLocation, salAmmoniac, 10, alchemicalSulfurInfo, oreCount, 100);
            helper.registerLiquefactionRecipe(miscHelper.getRecipeKey("theurgy.material_to_alchemical_sulfur", material.getName()), materialLocation, salAmmoniac, 10, alchemicalSulfurInfo, 1, 100);
            if (material.getType().isIngot()) {
                ResourceLocation rawMaterialLocation = miscHelper.getTagLocation("raw_materials", material.getName());
                helper.registerLiquefactionRecipe(miscHelper.getRecipeKey("theurgy.raw_material_to_alchemical_sulfur", material.getName()), rawMaterialLocation, salAmmoniac, 10, alchemicalSulfurInfo, 2, 100);
            }
            helper.registerIncubationRecipe(miscHelper.getRecipeKey("theurgy.alchemical_sulfur_to_material", material.getName()), mercuryShard, alchemicalSaltMineral, alchemicalSulfurLocation, materialLocation, 1, 100);
            if (!addTierTags) continue;
            String tier = TIER_FUNCTION.apply(material).name().toLowerCase(Locale.US);
            String type = (switch (material.getType()) {
                case MaterialType.INGOT, MaterialType.INGOT_LEGACY -> AlchemicalSulfurType.METALS;
                case MaterialType.GEM, MaterialType.CRYSTAL -> AlchemicalSulfurType.GEMS;
                default -> AlchemicalSulfurType.OTHER_MINERALS;
            }).name().toLowerCase(Locale.US);
            String base = "theurgy:alchemical_sulfurs";
            ((JAOPCAApi)api).registerItemTag(ResourceLocation.parse((String)String.join((CharSequence)"/", base, tier)), alchemicalSulfurInfo.asItem());
            ((JAOPCAApi)api).registerItemTag(ResourceLocation.parse((String)String.join((CharSequence)"/", base, type)), alchemicalSulfurInfo.asItem());
            ((JAOPCAApi)api).registerItemTag(ResourceLocation.parse((String)String.join((CharSequence)"/", base, type, tier)), alchemicalSulfurInfo.asItem());
        }
    }
}

