/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.theurgy.recipes;

import com.google.gson.JsonElement;
import com.klikli_dev.theurgy.content.recipe.IncubationRecipe;
import com.klikli_dev.theurgy.content.recipe.result.ItemRecipeResult;
import com.klikli_dev.theurgy.content.recipe.result.RecipeResult;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.utils.MiscHelper;

public class IncubationRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object mercury;
    public final Object salt;
    public final Object sulfur;
    public final Object output;
    public final int outputCount;
    public final int time;

    public IncubationRecipeSerializer(ResourceLocation key, Object mercury, Object salt, Object sulfur, Object output, int outputCount, int time) {
        this.key = Objects.requireNonNull(key);
        this.mercury = mercury;
        this.salt = salt;
        this.sulfur = sulfur;
        this.output = output;
        this.outputCount = outputCount;
        this.time = time;
    }

    @Override
    public JsonElement get() {
        Ingredient mercuryIng = MiscHelper.INSTANCE.getIngredient(this.mercury);
        if (mercuryIng == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.mercury));
        }
        Ingredient saltIng = MiscHelper.INSTANCE.getIngredient(this.salt);
        if (saltIng == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.salt));
        }
        Ingredient sulfurIng = MiscHelper.INSTANCE.getIngredient(this.sulfur);
        if (sulfurIng == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.sulfur));
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Empty output in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.output));
        }
        IncubationRecipe recipe = new IncubationRecipe(mercuryIng, saltIng, sulfurIng, (RecipeResult)new ItemRecipeResult(stack), this.time);
        return MiscHelper.INSTANCE.serializeRecipe((Recipe<?>)recipe);
    }
}

