/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.usefulmachinery.recipes;

import com.google.common.base.Strings;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.themcbrothers.usefulmachinery.core.MachineryItems;
import net.themcbrothers.usefulmachinery.recipe.CrushingRecipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.utils.MiscHelper;

public class CrushingRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final String group;
    public final Object input;
    public final Object output;
    public final int outputCount;
    public final Object secondOutput;
    public final int secondOutputCount;
    public final float secondOutputChance;
    public final int time;
    public final boolean supportsEfficiency;
    public final boolean supportsPrecision;

    public CrushingRecipeSerializer(ResourceLocation key, Object input, Object output, int outputCount, int time, boolean supportsEfficiency, boolean supportsPrecision) {
        this(key, "", input, output, outputCount, ItemStack.EMPTY, 0, 0.0f, time, supportsEfficiency, supportsPrecision);
    }

    public CrushingRecipeSerializer(ResourceLocation key, String group, Object input, Object output, int outputCount, int time, boolean supportsEfficiency, boolean supportsPrecision) {
        this(key, group, input, output, outputCount, ItemStack.EMPTY, 0, 0.0f, time, supportsEfficiency, supportsPrecision);
    }

    public CrushingRecipeSerializer(ResourceLocation key, Object input, Object output, int outputCount, Object secondOutput, int secondOutputCount, float secondOutputChance, int time, boolean supportsEfficiency, boolean supportsPrecision) {
        this(key, "", input, output, outputCount, secondOutput, secondOutputCount, secondOutputChance, time, supportsEfficiency, supportsPrecision);
    }

    public CrushingRecipeSerializer(ResourceLocation key, String group, Object input, Object output, int outputCount, Object secondOutput, int secondOutputCount, float secondOutputChance, int time, boolean supportsEfficiency, boolean supportsPrecision) {
        this.key = Objects.requireNonNull(key);
        this.group = Strings.nullToEmpty((String)group);
        this.input = input;
        this.output = output;
        this.outputCount = outputCount;
        this.secondOutput = secondOutput;
        this.secondOutputCount = secondOutputCount;
        this.secondOutputChance = secondOutputChance;
        this.time = time;
        this.supportsEfficiency = supportsEfficiency;
        this.supportsPrecision = supportsPrecision;
    }

    @Override
    public JsonElement get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.input));
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Empty output in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.output));
        }
        ItemStack secondStack = MiscHelper.INSTANCE.getItemStack(this.secondOutput, this.secondOutputCount);
        ArrayList<Ingredient.ItemValue> upgradeIngs = new ArrayList<Ingredient.ItemValue>(2);
        if (this.supportsEfficiency) {
            upgradeIngs.add(new Ingredient.ItemValue(new ItemStack((ItemLike)MachineryItems.EFFICIENCY_UPGRADE.asItem())));
        }
        if (this.supportsPrecision) {
            upgradeIngs.add(new Ingredient.ItemValue(new ItemStack((ItemLike)MachineryItems.PRECISION_UPGRADE.asItem())));
        }
        Ingredient upgradeIng = Ingredient.fromValues(upgradeIngs.stream());
        CrushingRecipe recipe = new CrushingRecipe(this.group, ing, upgradeIng, stack, secondStack, this.secondOutputChance, this.time);
        return MiscHelper.INSTANCE.serializeRecipe((Recipe<?>)recipe);
    }
}

