/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.fluids;

import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import thelm.jaopca.api.fluids.IFluidFormSettings;
import thelm.jaopca.api.fluids.IMaterialFormFluid;
import thelm.jaopca.api.fluids.IMaterialFormFluidType;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.functions.MemoizingSuppliers;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

public class JAOPCAFluidType
extends FluidType
implements IMaterialFormFluidType {
    private final IMaterialFormFluid fluid;
    private final IFluidFormSettings settings;
    private IntSupplier lightValue;
    private IntSupplier density;
    private IntSupplier temperature;
    private IntSupplier viscosity;
    private Supplier<Rarity> rarity;
    private DoubleSupplier motionScale;
    private BooleanSupplier canPushEntity;
    private BooleanSupplier canSwim;
    private DoubleSupplier fallDistanceModifier;
    private BooleanSupplier canExtinguish;
    private BooleanSupplier canDrown;
    private BooleanSupplier supportsBoating;
    private BooleanSupplier canHydrate;
    private BooleanSupplier canConvertToSource;

    public JAOPCAFluidType(IMaterialFormFluid fluid, IFluidFormSettings settings) {
        super(JAOPCAFluidType.getProperties(fluid, settings));
        this.fluid = fluid;
        this.settings = settings;
        this.lightValue = MemoizingSuppliers.of(settings.getLightValueFunction(), fluid::getMaterial);
        this.density = MemoizingSuppliers.of(settings.getDensityFunction(), fluid::getMaterial);
        this.temperature = MemoizingSuppliers.of(settings.getTemperatureFunction(), fluid::getMaterial);
        this.viscosity = MemoizingSuppliers.of(settings.getViscosityFunction(), fluid::getMaterial);
        this.rarity = MemoizingSuppliers.of(settings.getDisplayRarityFunction(), fluid::getMaterial);
        this.motionScale = MemoizingSuppliers.of(settings.getMotionScaleFunction(), fluid::getMaterial);
        this.canPushEntity = MemoizingSuppliers.of(settings.getCanPushEntityFunction(), fluid::getMaterial);
        this.canSwim = MemoizingSuppliers.of(settings.getCanSwimFunction(), fluid::getMaterial);
        this.fallDistanceModifier = MemoizingSuppliers.of(settings.getFallDistanceModifierFunction(), fluid::getMaterial);
        this.canExtinguish = MemoizingSuppliers.of(settings.getCanExtinguishFunction(), fluid::getMaterial);
        this.canDrown = MemoizingSuppliers.of(settings.getCanDrownFunction(), fluid::getMaterial);
        this.supportsBoating = MemoizingSuppliers.of(settings.getSupportsBoatingFunction(), fluid::getMaterial);
        this.canHydrate = MemoizingSuppliers.of(settings.getCanHydrateFunction(), fluid::getMaterial);
        this.canConvertToSource = MemoizingSuppliers.of(settings.getCanConvertToSourceFunction(), fluid::getMaterial);
    }

    public static FluidType.Properties getProperties(IMaterialFormFluid fluid, IFluidFormSettings settings) {
        FluidType.Properties prop = FluidType.Properties.create();
        prop.pathType(settings.getPathTypeFunction().apply(fluid.getMaterial()));
        prop.adjacentPathType(settings.getAdjacentPathTypeFunction().apply(fluid.getMaterial()));
        prop.sound(SoundActions.BUCKET_FILL, settings.getFillSoundSupplier().get());
        prop.sound(SoundActions.BUCKET_EMPTY, settings.getEmptySoundSupplier().get());
        prop.sound(SoundActions.FLUID_VAPORIZE, settings.getVaporizeSoundSupplier().get());
        return prop;
    }

    @Override
    public IForm getForm() {
        return this.fluid.getForm();
    }

    @Override
    public IMaterial getMaterial() {
        return this.fluid.getMaterial();
    }

    public FluidState getStateForPlacement(BlockAndTintGetter world, BlockPos pos, FluidStack stack) {
        return this.fluid.getSourceState();
    }

    public int getLightLevel() {
        return this.lightValue.getAsInt();
    }

    public int getDensity() {
        return this.density.getAsInt();
    }

    public int getTemperature() {
        return this.temperature.getAsInt();
    }

    public int getViscosity() {
        return this.viscosity.getAsInt();
    }

    public Rarity getRarity() {
        return this.rarity.get();
    }

    public double motionScale(Entity entity) {
        return this.motionScale.getAsDouble();
    }

    public boolean canPushEntity(Entity entity) {
        return this.canPushEntity.getAsBoolean();
    }

    public boolean canSwim(Entity entity) {
        return this.canSwim.getAsBoolean();
    }

    public float getFallDistanceModifier(Entity entity) {
        return (float)this.fallDistanceModifier.getAsDouble();
    }

    public boolean canExtinguish(Entity entity) {
        return this.canExtinguish.getAsBoolean();
    }

    public boolean canExtinguish(FluidState state, BlockGetter getter, BlockPos pos) {
        return this.canExtinguish.getAsBoolean();
    }

    public boolean canDrownIn(LivingEntity entity) {
        return this.canDrown.getAsBoolean();
    }

    public boolean supportsBoating(Boat boat) {
        return this.supportsBoating.getAsBoolean();
    }

    public boolean canHydrate(Entity entity) {
        return this.canHydrate.getAsBoolean();
    }

    public boolean canHydrate(FluidState state, BlockGetter getter, BlockPos pos, BlockState source, BlockPos sourcePos) {
        return this.canHydrate.getAsBoolean();
    }

    public boolean canHydrate(FluidStack stack) {
        return this.canHydrate.getAsBoolean();
    }

    public boolean canConvertToSource(FluidState state, LevelReader reader, BlockPos pos) {
        return this.canConvertToSource.getAsBoolean();
    }

    public boolean canConvertToSource(FluidStack stack) {
        return this.canConvertToSource.getAsBoolean();
    }

    @Override
    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){

            public int getTintColor() {
                return JAOPCAFluidType.this.fluid.getMaterial().getColor();
            }

            public ResourceLocation getStillTexture() {
                ResourceLocation location = BuiltInRegistries.FLUID.getKey((Object)JAOPCAFluidType.this.fluid.toFluid());
                if (MiscHelper.INSTANCE.hasResource(ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)("textures/fluid/" + location.getPath() + "_still.png")))) {
                    return ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)("fluid/" + location.getPath() + "_still"));
                }
                return ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)("fluid/" + JAOPCAFluidType.this.fluid.getMaterial().getModelType() + "/" + JAOPCAFluidType.this.fluid.getForm().getName() + "_still"));
            }

            public ResourceLocation getFlowingTexture() {
                ResourceLocation location = BuiltInRegistries.FLUID.getKey((Object)JAOPCAFluidType.this.fluid.toFluid());
                if (MiscHelper.INSTANCE.hasResource(ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)("textures/fluid/" + location.getPath() + "_flow.png")))) {
                    return ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)("fluid/" + location.getPath() + "_flow"));
                }
                return ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)("fluid/" + JAOPCAFluidType.this.fluid.getMaterial().getModelType() + "/" + JAOPCAFluidType.this.fluid.getForm().getName() + "_flow"));
            }
        });
    }

    public Component getDescription() {
        return ApiImpl.INSTANCE.currentLocalizer().localizeMaterialForm("fluid_type.jaopca." + this.fluid.getForm().getName(), this.fluid.getMaterial(), this.getDescriptionId());
    }

    public Component getDescription(FluidStack stack) {
        return this.getDescription();
    }
}

