/*
 * Decompiled with CFR 0.152.
 */
package jeresources.compatibility.api;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jeresources.api.IDungeonRegistry;
import jeresources.entry.DungeonEntry;
import jeresources.registry.DungeonRegistry;
import jeresources.util.LogHelper;
import jeresources.util.LootTableFetcher;
import jeresources.util.LootTableHelper;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.NotNull;

public class DungeonRegistryImpl
implements IDungeonRegistry {
    private static List<Tuple<String, String>> categoryMapping = new LinkedList<Tuple<String, String>>();
    private static Map<String, ResourceKey<LootTable>> rawRegisters = new HashMap<String, ResourceKey<LootTable>>();
    private static List<DungeonEntry> preppedRegisters = new LinkedList<DungeonEntry>();

    protected DungeonRegistryImpl() {
    }

    @Override
    public void registerCategory(@NotNull String category, @NotNull String localization) {
        categoryMapping.add((Tuple<String, String>)new Tuple((Object)category, (Object)localization));
    }

    @Override
    public void registerChest(@NotNull String category, @NotNull ResourceKey<LootTable> tableLocation) {
        rawRegisters.put(category, tableLocation);
    }

    @Override
    public void registerChest(@NotNull String category, @NotNull LootTable lootTable) {
        try {
            preppedRegisters.add(new DungeonEntry(category, lootTable));
        }
        catch (Exception e) {
            LogHelper.debug("Bad dungeon chest registry for category %s", category);
        }
    }

    protected static void commit() {
        categoryMapping.forEach(t -> DungeonRegistry.addCategoryMapping((String)t.getA(), (String)t.getB()));
        preppedRegisters.forEach(entry -> DungeonRegistry.getInstance().registerDungeonEntry((DungeonEntry)entry));
        LootTableFetcher lootTableFetcher = LootTableHelper.getLootTableFetcher();
        rawRegisters.entrySet().stream().map(entry -> {
            try {
                return new DungeonEntry((String)entry.getKey(), lootTableFetcher.getLootTable((ResourceKey<LootTable>)((ResourceKey)entry.getValue())));
            }
            catch (Exception e) {
                LogHelper.debug("Bad dungeon chest registry for category %s", entry.getKey());
                return null;
            }
        }).forEach(entry -> DungeonRegistry.getInstance().registerDungeonEntry((DungeonEntry)entry));
    }
}

