/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.legendarytooltips;

import com.anthonyhilyard.iceberg.events.client.RenderTooltipEvents;
import com.anthonyhilyard.iceberg.services.IKeyMappingRegistrar;
import com.anthonyhilyard.iceberg.services.Services;
import com.anthonyhilyard.iceberg.util.Tooltips;
import com.anthonyhilyard.legendarytooltips.config.LegendaryTooltipsConfig;
import com.anthonyhilyard.legendarytooltips.tooltip.ItemModelComponent;
import com.anthonyhilyard.legendarytooltips.tooltip.TooltipDecor;
import com.anthonyhilyard.legendarytooltips.tooltip.TooltipScroll;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.Map;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LegendaryTooltips {
    public static final String MODID = "legendarytooltips";
    public static final Logger LOGGER = LogManager.getLogger((String)"legendarytooltips");
    public static final int NUM_FRAMES = 16;
    private static Map<Integer, ItemStack> lastTooltipItems = Maps.newHashMap();
    public static final KeyMapping scrollTooltips = Services.getKeyMappingRegistrar().registerMapping(new KeyMapping("legendarytooltips.key.scrollTooltips", InputConstants.Type.KEYSYM, 340, "key.categories.inventory"), IKeyMappingRegistrar.KeyMappingContext.NO_CONFLICT);
    public static boolean scrollTooltipsKeyDown = false;

    public static void init() {
        LegendaryTooltipsConfig.register(LegendaryTooltipsConfig.class, (String)MODID);
    }

    public static RenderTooltipEvents.GatherResult onGatherComponentsEvent(ItemStack itemStack, int screenWidth, int screenHeight, List<Either<FormattedText, TooltipComponent>> tooltipElements, int maxWidth, int index) {
        if (LegendaryTooltipsConfig.getInstance().compactTooltips.get().booleanValue()) {
            for (int i = 0; i < tooltipElements.size(); ++i) {
                TranslatableContents contents;
                MutableComponent component;
                ComponentContents componentContents;
                FormattedText text;
                if (!tooltipElements.get(i).left().isPresent() || !((text = (FormattedText)tooltipElements.get(i).left().get()) instanceof MutableComponent) || !((componentContents = (component = (MutableComponent)text).getContents()) instanceof TranslatableContents) || !(contents = (TranslatableContents)componentContents).getKey().startsWith("item.modifiers.")) continue;
                tooltipElements.remove(i);
                if ((tooltipElements.size() <= i - 1 || i <= 0 || !tooltipElements.get(i - 1).right().isPresent() || tooltipElements.get(i - 1).right().get() != CommonComponents.EMPTY) && (!tooltipElements.get(i - 1).left().isPresent() || !((FormattedText)tooltipElements.get(i - 1).left().get()).getString().isEmpty())) continue;
                tooltipElements.remove(i - 1);
            }
        }
        if (LegendaryTooltipsConfig.showModelForItem(itemStack) && !tooltipElements.isEmpty() && tooltipElements.get(0).left().isPresent()) {
            tooltipElements.add(0, (Either<FormattedText, TooltipComponent>)Either.right((Object)new ItemModelComponent(itemStack)));
        }
        if (LegendaryTooltipsConfig.getMaxTooltipWidth() < maxWidth || maxWidth == -1) {
            maxWidth = LegendaryTooltipsConfig.getMaxTooltipWidth();
        }
        return new RenderTooltipEvents.GatherResult(InteractionResult.PASS, maxWidth, tooltipElements);
    }

    public static void onRenderTick(DeltaTracker tracker) {
        if (LegendaryTooltipsConfig.getInstance() == null || !LegendaryTooltipsConfig.getInstance().isLoaded()) {
            return;
        }
        float deltaTime = tracker.getRealtimeDeltaTicks() * 0.05f;
        TooltipDecor.updateTimer(deltaTime);
        ItemModelComponent.updateTimer(deltaTime);
        if (!Tooltips.anyTooltipsVisible()) {
            TooltipDecor.resetTimer();
            TooltipScroll.resetAll();
            lastTooltipItems.clear();
        }
    }

    private static boolean areStacksEqual(ItemStack first, ItemStack second) {
        if (first == second) {
            return true;
        }
        return ItemStack.hashItemAndComponents((ItemStack)first) + first.getCount() == ItemStack.hashItemAndComponents((ItemStack)second) + second.getCount();
    }

    public static RenderTooltipEvents.ColorExtResult onTooltipColorEvent(ItemStack stack, GuiGraphics graphics, int x, int y, Font font, int backgroundStart, int backgroundEnd, int borderStart, int borderEnd, List<ClientTooltipComponent> components, boolean comparison, int index) {
        RenderTooltipEvents.ColorExtResult result = new RenderTooltipEvents.ColorExtResult(backgroundStart, backgroundEnd, borderStart, borderEnd);
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.level == null || minecraft.level.registryAccess() == null) {
            return result;
        }
        if (!LegendaryTooltips.areStacksEqual(lastTooltipItems.computeIfAbsent(index, k -> ItemStack.EMPTY), stack)) {
            TooltipDecor.resetTimer();
            TooltipScroll.reset(index);
            lastTooltipItems.put(index, stack);
        }
        LegendaryTooltipsConfig.FrameDefinition frameDefinition = LegendaryTooltipsConfig.getDefinitionColors(stack, borderStart, borderEnd, backgroundStart, backgroundEnd, (HolderLookup.Provider)minecraft.level.registryAccess());
        TooltipDecor.setCurrentTooltipBorderStart(frameDefinition.startBorder().get());
        TooltipDecor.setCurrentTooltipBorderEnd(frameDefinition.endBorder().get());
        TooltipDecor.setCurrentTooltipBackgroundStart(frameDefinition.startBackground().get());
        TooltipDecor.setCurrentTooltipBackgroundEnd(frameDefinition.endBackground().get());
        return new RenderTooltipEvents.ColorExtResult(frameDefinition.startBackground().get().intValue(), frameDefinition.endBackground().get().intValue(), frameDefinition.startBorder().get().intValue(), frameDefinition.endBorder().get().intValue());
    }

    public static void onPostTooltipEvent(ItemStack stack, GuiGraphics graphics, int x, int y, Font font, int width, int height, List<ClientTooltipComponent> components, boolean comparison, int index) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.level == null || minecraft.level.registryAccess() == null) {
            return;
        }
        LegendaryTooltipsConfig.FrameDefinition frameDefinition = LegendaryTooltipsConfig.getInstance().getFrameDefinition(stack, (HolderLookup.Provider)minecraft.level.registryAccess());
        PoseStack poseStack = graphics.pose();
        if (LegendaryTooltipsConfig.getInstance().tooltipShadow.get().booleanValue()) {
            TooltipDecor.drawShadow(poseStack, x, y, width, height);
        }
        TooltipDecor.drawBorder(poseStack, x, y, width, height, stack, components, font, frameDefinition, comparison, index);
    }
}

