/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicdoorknob.blocks;

import com.tomboshoven.minecraft.magicdoorknob.blocks.Blocks;
import com.tomboshoven.minecraft.magicdoorknob.blocks.MagicDoorwayBlock;
import com.tomboshoven.minecraft.magicdoorknob.blocks.MagicDoorwayPartBaseBlock;
import com.tomboshoven.minecraft.magicdoorknob.blocks.entities.MagicDoorBlockEntity;
import com.tomboshoven.minecraft.magicdoorknob.blocks.entities.MagicDoorwayPartBaseBlockEntity;
import com.tomboshoven.minecraft.magicdoorknob.items.MagicDoorknobItem;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.util.DeferredSoundType;

public class MagicDoorBlock
extends MagicDoorwayPartBaseBlock {
    public static final EnumProperty<MagicDoorwayPartBaseBlock.EnumPartType> PART = EnumProperty.create((String)"part", MagicDoorwayPartBaseBlock.EnumPartType.class);
    public static final EnumProperty<Direction> HORIZONTAL_FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final VoxelShape[] SHAPES = new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0)};

    MagicDoorBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, @Nullable Entity entity) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof MagicDoorBlockEntity) {
            BlockState textureBlock = ((MagicDoorwayPartBaseBlockEntity)blockEntity).getBaseBlockState();
            SoundType actualSoundType = textureBlock.getBlock().getSoundType(textureBlock, world, pos, null);
            return new DeferredSoundType(actualSoundType.volume, actualSoundType.pitch, () -> SoundEvents.WOODEN_DOOR_CLOSE, () -> ((SoundType)actualSoundType).getStepSound(), () -> SoundEvents.WOODEN_DOOR_OPEN, () -> ((SoundType)actualSoundType).getHitSound(), () -> ((SoundType)actualSoundType).getFallSound());
        }
        return super.getSoundType(state, world, pos, entity);
    }

    @Nullable
    private static MagicDoorknobItem getDoorknob(BlockGetter world, BlockPos pos) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof MagicDoorBlockEntity) {
            return ((MagicDoorwayPartBaseBlockEntity)blockEntity).getDoorknob();
        }
        return null;
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        MagicDoorwayPartBaseBlock.EnumPartType part = (MagicDoorwayPartBaseBlock.EnumPartType)((Object)state.getValue(PART));
        MagicDoorBlock.breakDoorway(worldIn, pos, (Direction)state.getValue(HORIZONTAL_FACING), part);
        if (part == MagicDoorwayPartBaseBlock.EnumPartType.TOP) {
            MagicDoorknobItem doorknob = MagicDoorBlock.getDoorknob((BlockGetter)worldIn, pos);
            if (doorknob != null) {
                Containers.dropItemStack((Level)worldIn, (double)pos.getX(), (double)((float)pos.getY() - 0.5f), (double)pos.getZ(), (ItemStack)new ItemStack((ItemLike)doorknob, 1));
            }
            worldIn.destroyBlock(pos.below(), false);
        } else {
            worldIn.destroyBlock(pos.above(), false);
        }
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }

    private static void breakDoorway(Level world, BlockPos pos, Direction facing, MagicDoorwayPartBaseBlock.EnumPartType part) {
        Direction doorwayFacing = facing.getOpposite();
        MagicDoorknobItem doorknob = MagicDoorBlock.getDoorknob((BlockGetter)world, pos);
        double depth = doorknob == null ? 128.0 : doorknob.getDepth();
        int i = 1;
        while ((double)i <= depth) {
            BlockPos blockPos = pos.relative(doorwayFacing, i);
            BlockState state = world.getBlockState(blockPos);
            if (state.getBlock() == Blocks.MAGIC_DOORWAY.get()) {
                if (((Boolean)state.getValue((Property)MagicDoorwayBlock.OPEN_EAST_WEST)).booleanValue() && ((Boolean)state.getValue((Property)MagicDoorwayBlock.OPEN_NORTH_SOUTH)).booleanValue()) {
                    BlockState newState = (BlockState)state.setValue((Property)(facing.getAxis() == Direction.Axis.X ? MagicDoorwayBlock.OPEN_EAST_WEST : MagicDoorwayBlock.OPEN_NORTH_SOUTH), (Comparable)Boolean.valueOf(false));
                    if (part == MagicDoorwayPartBaseBlock.EnumPartType.BOTTOM && ((Boolean)state.getValue((Property)MagicDoorwayBlock.OPEN_CROSS_TOP_BOTTOM)).booleanValue()) {
                        newState = (BlockState)((BlockState)state.setValue(MagicDoorwayBlock.PART, (Comparable)((Object)MagicDoorwayPartBaseBlock.EnumPartType.TOP))).setValue((Property)MagicDoorwayBlock.OPEN_CROSS_TOP_BOTTOM, (Comparable)Boolean.valueOf(false));
                    }
                    world.setBlockAndUpdate(blockPos, newState);
                } else {
                    world.destroyBlock(blockPos, false);
                }
            }
            ++i;
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPES[((Direction)state.getValue(HORIZONTAL_FACING)).get2DDataValue()];
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PART, HORIZONTAL_FACING});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new MagicDoorBlockEntity(pos, state);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (!level.isClientSide) {
            level.destroyBlock(pos, false);
        }
        return InteractionResult.SUCCESS;
    }
}

