/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicdoorknob.blocks.entities;

import com.tomboshoven.minecraft.magicdoorknob.items.Items;
import com.tomboshoven.minecraft.magicdoorknob.items.MagicDoorknobItem;
import com.tomboshoven.minecraft.magicdoorknob.modeldata.ModelTextureProperty;
import com.tomboshoven.minecraft.magicdoorknob.modeldata.TextureSourceReference;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;

public abstract class MagicDoorwayPartBaseBlockEntity
extends BlockEntity {
    private static final ModelTextureProperty TEXTURE_MAIN = ModelTextureProperty.get(ResourceLocation.fromNamespaceAndPath((String)"property", (String)"texture_main"));
    private static final ModelTextureProperty TEXTURE_HIGHLIGHT = ModelTextureProperty.get(ResourceLocation.fromNamespaceAndPath((String)"property", (String)"texture_highlight"));
    public static final ModelTextureProperty TEXTURE_PARTICLE = ModelTextureProperty.get(ResourceLocation.fromNamespaceAndPath((String)"property", (String)"texture_particle"));
    private BlockState baseBlockState = Blocks.AIR.defaultBlockState();
    private MagicDoorknobItem doorknob;

    MagicDoorwayPartBaseBlockEntity(BlockEntityType<? extends MagicDoorwayPartBaseBlockEntity> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(compound, lookupProvider);
        this.saveInternal(compound);
    }

    private void saveInternal(CompoundTag compound) {
        compound.put("baseBlock", (Tag)NbtUtils.writeBlockState((BlockState)this.baseBlockState));
        if (this.doorknob != null) {
            compound.putString("doorknobType", this.doorknob.getTypeName());
        }
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(compound, lookupProvider);
        this.loadInternal(compound);
    }

    private void loadInternal(CompoundTag compound) {
        HolderLookup.RegistryLookup holdergetter = this.level != null ? this.level.holderLookup(Registries.BLOCK) : BuiltInRegistries.BLOCK.asLookup();
        this.baseBlockState = NbtUtils.readBlockState((HolderGetter)holdergetter, (CompoundTag)compound.getCompound("baseBlock"));
        String doorknobType = compound.getString("doorknobType");
        DeferredItem<MagicDoorknobItem> deferredDoorknob = Items.DOORKNOBS.get(doorknobType);
        this.doorknob = deferredDoorknob != null ? (MagicDoorknobItem)((Object)deferredDoorknob.get()) : null;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider lookupProvider) {
        CompoundTag updateTag = super.getUpdateTag(lookupProvider);
        this.saveInternal(updateTag);
        return updateTag;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        this.loadInternal(pkt.getTag());
        this.requestModelDataUpdate();
    }

    @NotNull
    public ModelData getModelData() {
        Level level = this.getLevel();
        BlockPos blockPos = this.getBlockPos();
        Material emptyMaterial = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.fromNamespaceAndPath((String)"magic_doorknob", (String)"block/empty"));
        TextureSourceReference.MaterialTextureSource fallbackReference = new TextureSourceReference.MaterialTextureSource(emptyMaterial);
        TextureSourceReference.BlockParticle particleTextureSourceReference = new TextureSourceReference.BlockParticle(this.baseBlockState, fallbackReference);
        TextureSourceReference.BlockLookup blockTextureSourceReference = new TextureSourceReference.BlockLookup(level, blockPos, this.baseBlockState, fallbackReference);
        Record doorknobTextureSourceReference = this.doorknob == null ? blockTextureSourceReference : new TextureSourceReference.MaterialTextureSource(this.doorknob.getMainMaterial());
        return ModelData.builder().with((ModelProperty)TEXTURE_MAIN, (Object)blockTextureSourceReference).with((ModelProperty)TEXTURE_HIGHLIGHT, (Object)doorknobTextureSourceReference).with((ModelProperty)TEXTURE_PARTICLE, (Object)particleTextureSourceReference).build();
    }

    public BlockState getBaseBlockState() {
        return this.baseBlockState;
    }

    public void setBaseBlockState(BlockState baseBlockState) {
        this.baseBlockState = baseBlockState;
    }

    @Nullable
    public MagicDoorknobItem getDoorknob() {
        return this.doorknob;
    }

    public void setDoorknob(MagicDoorknobItem doorknob) {
        this.doorknob = doorknob;
    }
}

