/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicdoorknob.client.modelloaders.textured;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.tomboshoven.minecraft.magicdoorknob.client.modelloaders.textured.IItemStackTextureMapperProvider;
import com.tomboshoven.minecraft.magicdoorknob.client.modelloaders.textured.ITextureMapper;
import com.tomboshoven.minecraft.magicdoorknob.client.modelloaders.textured.PropertySprite;
import com.tomboshoven.minecraft.magicdoorknob.modeldata.TextureSourceReference;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.BakedModelWrapper;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

class TexturedBakedModel<T extends BakedModel>
extends BakedModelWrapper<T> {
    private final Function<? super Material, ? extends TextureAtlasSprite> bakedTextureGetter;
    private final ITextureMapper textureMapper;
    private static final VertexFormat VERTEX_FORMAT = DefaultVertexFormat.BLOCK;
    private static final VertexFormatElement VERTEX_FORMAT_ELEMENT_UV = VERTEX_FORMAT.getElements().stream().filter(el -> el.usage() == VertexFormatElement.Usage.UV && el.index() == 0).findFirst().orElseThrow();
    private static final int VERTEX_FORMAT_ELEMENT_UV_OFFSET = VERTEX_FORMAT.getOffset(VERTEX_FORMAT_ELEMENT_UV);

    TexturedBakedModel(T originalModel, Function<? super Material, ? extends TextureAtlasSprite> bakedTextureGetter, ITextureMapper textureMapper) {
        super(originalModel);
        this.bakedTextureGetter = bakedTextureGetter;
        this.textureMapper = textureMapper;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType renderType) {
        List quads = this.originalModel.getQuads(state, side, rand, extraData, renderType);
        return quads.stream().map(quad -> {
            TextureAtlasSprite sprite = quad.getSprite();
            if (sprite instanceof PropertySprite) {
                TextureSourceReference textureSourceReference = this.textureMapper.mapSprite((PropertySprite)sprite, state, extraData);
                if (textureSourceReference != null) {
                    TextureSourceReference.LookupResult lookupResult = textureSourceReference.lookup(this.bakedTextureGetter, quad.getDirection(), rand);
                    return TexturedBakedModel.retexture(quad, lookupResult.sprite(), lookupResult.tintIndex());
                }
                return null;
            }
            return quad;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static BakedQuad retexture(BakedQuad quad, TextureAtlasSprite sprite, @Nullable Integer tintIndex) {
        int[] vertexData = (int[])quad.getVertices().clone();
        int stride = VERTEX_FORMAT.getVertexSize();
        int eltOffset = VERTEX_FORMAT_ELEMENT_UV.type().size();
        float minU = sprite.getU0();
        float maxU = sprite.getU1();
        float minV = sprite.getV0();
        float maxV = sprite.getV1();
        int idx = VERTEX_FORMAT_ELEMENT_UV_OFFSET;
        for (int vertex = 0; vertex < 4; ++vertex) {
            float vertexU = Float.intBitsToFloat(TexturedBakedModel.getAtByteOffset(vertexData, idx));
            float vertexV = Float.intBitsToFloat(TexturedBakedModel.getAtByteOffset(vertexData, idx + eltOffset));
            float newU = minU + (maxU - minU) * vertexU;
            float newV = minV + (maxV - minV) * vertexV;
            TexturedBakedModel.putAtByteOffset(vertexData, idx, Float.floatToRawIntBits(newU));
            TexturedBakedModel.putAtByteOffset(vertexData, idx + eltOffset, Float.floatToRawIntBits(newV));
            idx += stride;
        }
        return new BakedQuad(vertexData, tintIndex == null ? quad.getTintIndex() : tintIndex.intValue(), quad.getDirection(), sprite, quad.isShade());
    }

    private static int getAtByteOffset(int[] inData, int offset) {
        int index = offset / 4;
        int lsb = inData[index];
        int shift = offset % 4 * 8;
        if (shift == 0) {
            return inData[index];
        }
        int msb = inData[index + 1];
        return lsb >>> shift | msb << 32 - shift;
    }

    private static void putAtByteOffset(int[] outData, int offset, int value) {
        int index = offset / 4;
        int shift = offset % 4 * 8;
        if (shift == 0) {
            outData[index] = value;
            return;
        }
        int lsbMask = -1 >>> 32 - shift;
        int msbMask = -1 << shift;
        outData[index] = outData[index] & lsbMask | value << shift;
        outData[index + 1] = outData[index + 1] & msbMask | value >>> 32 - shift;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        return this.getQuads(state, side, rand, ModelData.EMPTY, null);
    }

    public ItemOverrides getOverrides() {
        return new TexturedOverrideList(super.getOverrides());
    }

    public TextureAtlasSprite getParticleIcon(@Nonnull ModelData data) {
        TextureSourceReference textureSourceReference;
        TextureAtlasSprite icon = super.getParticleIcon(data);
        if (icon instanceof PropertySprite && (textureSourceReference = this.textureMapper.mapSprite((PropertySprite)icon, null, data)) != null) {
            return textureSourceReference.lookup(this.bakedTextureGetter).sprite();
        }
        return icon;
    }

    private class TexturedOverrideList
    extends ItemOverrides {
        private final ItemOverrides wrappedOverrideList;

        TexturedOverrideList(ItemOverrides wrappedOverrideList) {
            this.wrappedOverrideList = wrappedOverrideList;
        }

        public ImmutableList<ItemOverrides.BakedOverride> getOverrides() {
            return this.wrappedOverrideList.getOverrides();
        }

        @Nullable
        public BakedModel resolve(BakedModel model, ItemStack stack, @Nullable ClientLevel worldIn, @Nullable LivingEntity entityIn, int seed) {
            Item item = stack.getItem();
            if (item instanceof IItemStackTextureMapperProvider) {
                return new TexturedBakedModel<BakedModel>(model, TexturedBakedModel.this.bakedTextureGetter, ((IItemStackTextureMapperProvider)item).getTextureMapper(stack));
            }
            return this.wrappedOverrideList.resolve(model, stack, worldIn, entityIn, seed);
        }
    }
}

