/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicdoorknob.items;

import com.google.common.collect.Maps;
import com.tomboshoven.minecraft.magicdoorknob.items.MagicDoorknobItem;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class Items {
    public static final Map<String, DeferredItem<MagicDoorknobItem>> DOORKNOBS = Maps.newLinkedHashMap();
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"magic_doorknob");

    private Items() {
    }

    private static void addDoorknob(String typeName, Tier tier, ResourceLocation mainTexture, Supplier<Ingredient> ingredient) {
        DeferredItem item = ITEMS.register(String.format("magic_doorknob_%s", typeName), () -> new MagicDoorknobItem(new Item.Properties(), typeName, tier, mainTexture, ingredient));
        DOORKNOBS.put(typeName, (DeferredItem<MagicDoorknobItem>)item);
    }

    private static void addDoorknob(String typeName, Tier tier, String blockName) {
        Items.addDoorknob(typeName, tier, ResourceLocation.withDefaultNamespace((String)String.format("block/%s", blockName)), () -> ((Tier)tier).getRepairIngredient());
    }

    public static void register(IEventBus eventBus) {
        ITEMS.register(eventBus);
        eventBus.addListener(Items::registerCreativeTabs);
    }

    private static void registerCreativeTabs(BuildCreativeModeTabContentsEvent event) {
        if (CreativeModeTabs.TOOLS_AND_UTILITIES.equals(event.getTabKey())) {
            DOORKNOBS.values().forEach(arg_0 -> ((BuildCreativeModeTabContentsEvent)event).accept(arg_0));
        }
    }

    static {
        Items.addDoorknob("wood", (Tier)Tiers.WOOD, "oak_planks");
        Items.addDoorknob("stone", (Tier)Tiers.STONE, "stone");
        Items.addDoorknob("iron", (Tier)Tiers.IRON, "iron_block");
        Items.addDoorknob("gold", (Tier)Tiers.GOLD, "gold_block");
        Items.addDoorknob("diamond", (Tier)Tiers.DIAMOND, "diamond_block");
        Items.addDoorknob("netherite", (Tier)Tiers.NETHERITE, "netherite_block");
    }
}

