/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicdoorknob.items;

import com.tomboshoven.minecraft.magicdoorknob.blocks.Blocks;
import com.tomboshoven.minecraft.magicdoorknob.blocks.MagicDoorBlock;
import com.tomboshoven.minecraft.magicdoorknob.blocks.MagicDoorwayBlock;
import com.tomboshoven.minecraft.magicdoorknob.blocks.MagicDoorwayPartBaseBlock;
import com.tomboshoven.minecraft.magicdoorknob.blocks.entities.MagicDoorBlockEntity;
import com.tomboshoven.minecraft.magicdoorknob.blocks.entities.MagicDoorwayBlockEntity;
import com.tomboshoven.minecraft.magicdoorknob.blocks.entities.MagicDoorwayPartBaseBlockEntity;
import com.tomboshoven.minecraft.magicdoorknob.config.Config;
import java.util.function.Supplier;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class MagicDoorknobItem
extends Item {
    private final ResourceLocation mainTextureLocation;
    private final String typeName;
    private final Tier tier;
    private final Supplier<Ingredient> ingredient;
    public static final int MAX_DOORWAY_LENGTH = 128;

    MagicDoorknobItem(Item.Properties properties, String typeName, Tier tier, ResourceLocation mainTextureLocation, Supplier<Ingredient> ingredient) {
        super(properties);
        this.typeName = typeName;
        this.tier = tier;
        this.mainTextureLocation = mainTextureLocation;
        this.ingredient = ingredient;
    }

    private static boolean isEmpty(BlockGetter world, BlockPos pos, BlockPlaceContext useContext) {
        BlockState blockState = world.getBlockState(pos);
        return blockState.isAir() || blockState.canBeReplaced(useContext);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        if (!world.isClientSide) {
            Direction face = context.getClickedFace();
            BlockPos pos = context.getClickedPos();
            if (face == Direction.UP || face == Direction.DOWN) {
                return InteractionResult.FAIL;
            }
            BlockPlaceContext useContext = new BlockPlaceContext(context);
            if (this.canPlaceDoor((BlockGetter)world, pos, face, useContext)) {
                this.placeDoor(world, pos, face);
                this.placeDoorway(world, pos, face, useContext);
                context.getItemInHand().shrink(1);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.SUCCESS;
    }

    private void placeDoor(Level world, BlockPos pos, Direction facing) {
        BlockPos doorPos = pos.relative(facing);
        Block block = Blocks.MAGIC_DOOR.get();
        world.setBlockAndUpdate(doorPos, (BlockState)((BlockState)block.defaultBlockState().setValue(MagicDoorBlock.HORIZONTAL_FACING, (Comparable)facing)).setValue(MagicDoorBlock.PART, (Comparable)((Object)MagicDoorwayPartBaseBlock.EnumPartType.TOP)));
        BlockEntity topBlockEntity = world.getBlockEntity(doorPos);
        if (topBlockEntity instanceof MagicDoorBlockEntity) {
            MagicDoorBlockEntity topDoorBlockEntity = (MagicDoorBlockEntity)topBlockEntity;
            BlockState blockState = world.getBlockState(pos);
            if (blockState.is(Blocks.MAGIC_DOORWAY.get())) {
                BlockEntity blockEntity = world.getBlockEntity(pos);
                if (blockEntity instanceof MagicDoorwayBlockEntity) {
                    MagicDoorwayBlockEntity magicDoorwayBlockEntity = (MagicDoorwayBlockEntity)blockEntity;
                    topDoorBlockEntity.setBaseBlockState(magicDoorwayBlockEntity.getBaseBlockState());
                }
            } else {
                topDoorBlockEntity.setBaseBlockState(blockState);
            }
            topDoorBlockEntity.setDoorknob(this);
        }
        world.setBlockAndUpdate(doorPos.below(), (BlockState)((BlockState)block.defaultBlockState().setValue(MagicDoorBlock.HORIZONTAL_FACING, (Comparable)facing)).setValue(MagicDoorBlock.PART, (Comparable)((Object)MagicDoorwayPartBaseBlock.EnumPartType.BOTTOM)));
        BlockEntity bottomBlockEntity = world.getBlockEntity(doorPos.below());
        if (bottomBlockEntity instanceof MagicDoorBlockEntity) {
            MagicDoorBlockEntity bottomDoorBlockEntity = (MagicDoorBlockEntity)bottomBlockEntity;
            BlockState blockState = world.getBlockState(pos.below());
            if (blockState.is(Blocks.MAGIC_DOORWAY.get())) {
                BlockEntity blockEntity = world.getBlockEntity(pos.below());
                if (blockEntity instanceof MagicDoorwayBlockEntity) {
                    MagicDoorwayBlockEntity magicDoorwayBlockEntity = (MagicDoorwayBlockEntity)blockEntity;
                    bottomDoorBlockEntity.setBaseBlockState(magicDoorwayBlockEntity.getBaseBlockState());
                }
            } else {
                bottomDoorBlockEntity.setBaseBlockState(blockState);
            }
            bottomDoorBlockEntity.setDoorknob(this);
        }
        world.playSound(null, doorPos, SoundEvents.WOODEN_DOOR_OPEN, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private void placeDoorway(Level world, BlockPos pos, Direction facing, BlockPlaceContext useContext) {
        BlockPos elementPos;
        Direction doorwayFacing = facing.getOpposite();
        boolean isNorthSouth = facing == Direction.NORTH || facing == Direction.SOUTH;
        double depth = this.getDepth();
        int i = 0;
        while ((double)i < depth && (this.isReplaceable((BlockGetter)world, elementPos = pos.relative(doorwayFacing, i)) && !MagicDoorknobItem.isEmpty((BlockGetter)world, elementPos, useContext) || this.isReplaceable((BlockGetter)world, elementPos.below()) && !MagicDoorknobItem.isEmpty((BlockGetter)world, elementPos.below(), useContext))) {
            this.placeDoorwayElement(world, elementPos, isNorthSouth, MagicDoorwayPartBaseBlock.EnumPartType.TOP);
            this.placeDoorwayElement(world, elementPos.below(), isNorthSouth, MagicDoorwayPartBaseBlock.EnumPartType.BOTTOM);
            ++i;
        }
    }

    private void placeDoorwayElement(Level world, BlockPos pos, boolean isNorthSouth, MagicDoorwayPartBaseBlock.EnumPartType part) {
        if (this.isReplaceable((BlockGetter)world, pos)) {
            Block block;
            BlockState state = world.getBlockState(pos);
            if (state.is(block = Blocks.MAGIC_DOORWAY.get())) {
                BlockState newState = (BlockState)state.setValue((Property)(isNorthSouth ? MagicDoorwayBlock.OPEN_NORTH_SOUTH : MagicDoorwayBlock.OPEN_EAST_WEST), (Comparable)Boolean.valueOf(true));
                if (part == MagicDoorwayPartBaseBlock.EnumPartType.BOTTOM && state.getValue(MagicDoorwayBlock.PART) == MagicDoorwayPartBaseBlock.EnumPartType.TOP) {
                    newState = (BlockState)((BlockState)newState.setValue(MagicDoorwayBlock.PART, (Comparable)((Object)MagicDoorwayPartBaseBlock.EnumPartType.BOTTOM))).setValue((Property)MagicDoorwayBlock.OPEN_CROSS_TOP_BOTTOM, (Comparable)Boolean.valueOf(true));
                }
                world.setBlockAndUpdate(pos, newState);
            } else {
                world.setBlockAndUpdate(pos, (BlockState)((BlockState)((BlockState)block.defaultBlockState().setValue((Property)MagicDoorwayBlock.OPEN_NORTH_SOUTH, (Comparable)Boolean.valueOf(isNorthSouth))).setValue((Property)MagicDoorwayBlock.OPEN_EAST_WEST, (Comparable)Boolean.valueOf(!isNorthSouth))).setValue(MagicDoorwayBlock.PART, (Comparable)((Object)part)));
                BlockEntity blockEntity = world.getBlockEntity(pos);
                if (blockEntity instanceof MagicDoorwayBlockEntity) {
                    ((MagicDoorwayPartBaseBlockEntity)blockEntity).setBaseBlockState(state);
                    ((MagicDoorwayPartBaseBlockEntity)blockEntity).setDoorknob(this);
                }
            }
        }
    }

    private boolean canPlaceDoor(BlockGetter world, BlockPos pos, Direction facing, BlockPlaceContext useContext) {
        if (!this.isReplaceable(world, pos) || !this.isReplaceable(world, pos.below())) {
            return false;
        }
        return MagicDoorknobItem.isEmpty(world, pos.relative(facing), useContext) && MagicDoorknobItem.isEmpty(world, pos.relative(facing).below(), useContext);
    }

    private boolean isReplaceable(BlockGetter world, BlockPos pos) {
        BlockState blockState = world.getBlockState(pos);
        if (blockState.is(Blocks.MAGIC_DOORWAY.get())) {
            return true;
        }
        if (blockState.hasBlockEntity()) {
            return false;
        }
        if (blockState.getDestroySpeed(world, pos) < 0.0f) {
            return false;
        }
        return !blockState.is(this.tier.getIncorrectBlocksForDrops());
    }

    public Material getMainMaterial() {
        return new Material(InventoryMenu.BLOCK_ATLAS, this.mainTextureLocation);
    }

    public String getTypeName() {
        return this.typeName;
    }

    public Tier getTier() {
        return this.tier;
    }

    public double getDepth() {
        return Math.min((double)this.getTier().getSpeed() * (Double)Config.SERVER.doorwayMultiplier.get(), 128.0);
    }

    public Ingredient getIngredient() {
        return this.ingredient.get();
    }
}

