/*
 * Decompiled with CFR 0.152.
 */
package com.tomboshoven.minecraft.magicdoorknob.modeldata;

import java.util.Iterator;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;

public interface TextureSourceReference {
    default public LookupResult lookup(Function<? super Material, ? extends TextureAtlasSprite> sprites) {
        return this.lookup(sprites, null);
    }

    default public LookupResult lookup(Function<? super Material, ? extends TextureAtlasSprite> sprites, @Nullable RandomSource randomSource) {
        return this.lookup(sprites, Direction.NORTH, randomSource);
    }

    public LookupResult lookup(Function<? super Material, ? extends TextureAtlasSprite> var1, Direction var2, @Nullable RandomSource var3);

    public record LookupResult(TextureAtlasSprite sprite, @Nullable Integer tintIndex) {
    }

    public record BlockLookup(@Nullable Level level, BlockPos pos, BlockState blockState, TextureSourceReference fallback) implements TextureSourceReference
    {
        @Override
        public LookupResult lookup(Function<? super Material, ? extends TextureAtlasSprite> sprites, Direction direction, @Nullable RandomSource randomSource) {
            Iterator iterator;
            Minecraft minecraft = Minecraft.getInstance();
            BlockModelShaper blockModelShaper = minecraft.getBlockRenderer().getBlockModelShaper();
            BakedModel blockModel = blockModelShaper.getBlockModel(this.blockState);
            if (randomSource == null) {
                randomSource = RandomSource.create();
            }
            if ((iterator = blockModel.getQuads(this.blockState, direction, randomSource, ModelData.EMPTY, null).iterator()).hasNext()) {
                BakedQuad quad = (BakedQuad)iterator.next();
                return new LookupResult(quad.getSprite(), quad.getTintIndex());
            }
            LookupResult result = null;
            for (BakedQuad quad : blockModel.getQuads(this.blockState, null, randomSource, ModelData.EMPTY, null)) {
                Direction quadDirection = quad.getDirection();
                if (quadDirection.getAxis().isVertical() != direction.getAxis().isVertical()) continue;
                result = new LookupResult(quad.getSprite(), quad.getTintIndex());
                if (quadDirection != direction) continue;
                return result;
            }
            if (result == null) {
                return this.fallback.lookup(sprites, direction, randomSource);
            }
            return result;
        }
    }

    public record BlockParticle(BlockState blockState, TextureSourceReference fallback) implements TextureSourceReference
    {
        @Override
        public LookupResult lookup(Function<? super Material, ? extends TextureAtlasSprite> sprites, Direction direction, @Nullable RandomSource randomSource) {
            Minecraft minecraft = Minecraft.getInstance();
            BlockModelShaper blockModelShaper = minecraft.getBlockRenderer().getBlockModelShaper();
            BakedModel blockModel = blockModelShaper.getBlockModel(this.blockState);
            TextureAtlasSprite icon = blockModel.getParticleIcon();
            if (icon == minecraft.getTextureAtlas(icon.atlasLocation()).apply(MissingTextureAtlasSprite.getLocation())) {
                return this.fallback.lookup(sprites, direction, randomSource);
            }
            return new LookupResult(icon, null);
        }
    }

    public record MaterialTextureSource(Material material) implements TextureSourceReference
    {
        @Override
        public LookupResult lookup(Function<? super Material, ? extends TextureAtlasSprite> sprites, Direction direction, @Nullable RandomSource randomSource) {
            return new LookupResult(sprites.apply((Material)this.material), null);
        }
    }
}

