/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntFunction;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.text.APILang;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTranslationKey;
import mekanism.api.text.ILangEntry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public enum Upgrade implements IHasTranslationKey.IHasEnumNameTranslationKey,
StringRepresentable
{
    SPEED("speed", APILang.UPGRADE_SPEED, APILang.UPGRADE_SPEED_DESCRIPTION, 8, EnumColor.RED),
    ENERGY("energy", APILang.UPGRADE_ENERGY, APILang.UPGRADE_ENERGY_DESCRIPTION, 8, EnumColor.BRIGHT_GREEN),
    FILTER("filter", APILang.UPGRADE_FILTER, APILang.UPGRADE_FILTER_DESCRIPTION, 1, EnumColor.DARK_AQUA),
    CHEMICAL("chemical", APILang.UPGRADE_CHEMICAL, APILang.UPGRADE_CHEMICAL_DESCRIPTION, 8, EnumColor.YELLOW),
    MUFFLING("muffling", APILang.UPGRADE_MUFFLING, APILang.UPGRADE_MUFFLING_DESCRIPTION, 1, EnumColor.INDIGO),
    ANCHOR("anchor", APILang.UPGRADE_ANCHOR, APILang.UPGRADE_ANCHOR_DESCRIPTION, 1, EnumColor.DARK_GREEN),
    STONE_GENERATOR("stone_generator", APILang.UPGRADE_STONE_GENERATOR, APILang.UPGRADE_STONE_GENERATOR_DESCRIPTION, 1, EnumColor.ORANGE);

    public static final Codec<Upgrade> CODEC;
    public static final IntFunction<Upgrade> BY_ID;
    public static final StreamCodec<ByteBuf, Upgrade> STREAM_CODEC;
    private final String name;
    private final ILangEntry langKey;
    private final ILangEntry descLangKey;
    private final int maxStack;
    private final EnumColor color;

    private Upgrade(String name, ILangEntry langKey, ILangEntry descLangKey, int maxStack, EnumColor color) {
        this.name = name;
        this.langKey = langKey;
        this.descLangKey = descLangKey;
        this.maxStack = maxStack;
        this.color = color;
    }

    public static Map<Upgrade, Integer> buildMap(@Nullable CompoundTag nbtTags) {
        EnumMap<Upgrade, Integer> upgrades = null;
        if (nbtTags != null && nbtTags.contains("upgrades", 9)) {
            ListTag list = nbtTags.getList("upgrades", 10);
            for (int tagCount = 0; tagCount < list.size(); ++tagCount) {
                CompoundTag compound = list.getCompound(tagCount);
                Upgrade upgrade = BY_ID.apply(compound.getInt("type"));
                int installed = Math.max(compound.getInt("amount"), 0);
                if (installed <= 0) continue;
                if (upgrades == null) {
                    upgrades = new EnumMap<Upgrade, Integer>(Upgrade.class);
                }
                upgrades.put(upgrade, installed);
            }
        }
        return upgrades == null ? Collections.emptyMap() : upgrades;
    }

    public static void saveMap(Map<Upgrade, Integer> upgrades, CompoundTag nbtTags) {
        ListTag list = new ListTag(upgrades.size());
        for (Map.Entry<Upgrade, Integer> entry : upgrades.entrySet()) {
            list.add((Object)entry.getKey().getTag(entry.getValue()));
        }
        nbtTags.put("upgrades", (Tag)list);
    }

    public CompoundTag getTag(int amount) {
        CompoundTag compound = new CompoundTag();
        compound.putInt("type", this.ordinal());
        compound.putInt("amount", amount);
        return compound;
    }

    public String getSerializedName() {
        return this.name;
    }

    @Override
    public String getTranslationKey() {
        return this.langKey.getTranslationKey();
    }

    public Component getDescription() {
        return this.descLangKey.translate();
    }

    public int getMax() {
        return this.maxStack;
    }

    public EnumColor getColor() {
        return this.color;
    }

    static {
        StringRepresentable[] values = Upgrade.values();
        Function nameLookup = StringRepresentable.createNameLookup((StringRepresentable[])values, Function.identity());
        Function<String, Upgrade> remapper = it -> "gas".equals(it) ? CHEMICAL : (Upgrade)nameLookup.apply(it);
        CODEC = new StringRepresentable.EnumCodec((Enum[])values, remapper);
        BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])Upgrade.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
    }

    public static interface IUpgradeInfoHandler {
        public List<Component> getInfo(Upgrade var1);
    }
}

