/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.datagen.recipe.builder;

import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.datagen.recipe.MekanismRecipeBuilder;
import mekanism.api.recipes.ChemicalChemicalToChemicalRecipe;
import mekanism.api.recipes.basic.BasicChemicalInfuserRecipe;
import mekanism.api.recipes.basic.BasicPigmentMixingRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;

@NothingNullByDefault
public class ChemicalChemicalToChemicalRecipeBuilder
extends MekanismRecipeBuilder<ChemicalChemicalToChemicalRecipeBuilder> {
    private final Factory factory;
    private final ChemicalStackIngredient leftInput;
    private final ChemicalStackIngredient rightInput;
    private final ChemicalStack output;

    protected ChemicalChemicalToChemicalRecipeBuilder(ChemicalStackIngredient leftInput, ChemicalStackIngredient rightInput, ChemicalStack output, Factory factory) {
        this.leftInput = leftInput;
        this.rightInput = rightInput;
        this.output = output;
        this.factory = factory;
    }

    public static ChemicalChemicalToChemicalRecipeBuilder chemicalInfusing(ChemicalStackIngredient leftInput, ChemicalStackIngredient rightInput, ChemicalStack output) {
        if (output.isEmpty()) {
            throw new IllegalArgumentException("This chemical infusing recipe requires a non empty chemical output.");
        }
        return new ChemicalChemicalToChemicalRecipeBuilder(leftInput, rightInput, output, BasicChemicalInfuserRecipe::new);
    }

    public static ChemicalChemicalToChemicalRecipeBuilder pigmentMixing(ChemicalStackIngredient leftInput, ChemicalStackIngredient rightInput, ChemicalStack output) {
        if (output.isEmpty()) {
            throw new IllegalArgumentException("This pigment mixing recipe requires a non empty chemical output.");
        }
        return new ChemicalChemicalToChemicalRecipeBuilder(leftInput, rightInput, output, BasicPigmentMixingRecipe::new);
    }

    protected ChemicalChemicalToChemicalRecipe asRecipe() {
        return this.factory.create(this.leftInput, this.rightInput, this.output);
    }

    @FunctionalInterface
    public static interface Factory {
        public ChemicalChemicalToChemicalRecipe create(ChemicalStackIngredient var1, ChemicalStackIngredient var2, ChemicalStack var3);
    }
}

