/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.List;
import mekanism.api.math.MathUtils;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.bar.GuiVerticalRateBar;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiEnergyGauge;
import mekanism.client.gui.element.tab.GuiEnergyTab;
import mekanism.client.gui.element.tab.GuiMatrixTab;
import mekanism.client.render.IFancyFontRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.content.matrix.MatrixMultiblockData;
import mekanism.common.inventory.container.tile.EmptyTileContainer;
import mekanism.common.tile.multiblock.TileEntityInductionCasing;
import mekanism.common.util.text.EnergyDisplay;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public class GuiMatrixStats
extends GuiMekanismTile<TileEntityInductionCasing, EmptyTileContainer<TileEntityInductionCasing>> {
    public GuiMatrixStats(EmptyTileContainer<TileEntityInductionCasing> container, Inventory inv, Component title) {
        super(container, inv, title);
        this.titleLabelY = 5;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget(new GuiMatrixTab((IGuiWrapper)this, (TileEntityInductionCasing)this.tile, GuiMatrixTab.MatrixTab.MAIN));
        this.addRenderableWidget(new GuiEnergyGauge(new GuiEnergyGauge.IEnergyInfoHandler(){

            @Override
            public long getEnergy() {
                return ((MatrixMultiblockData)((TileEntityInductionCasing)GuiMatrixStats.this.tile).getMultiblock()).getEnergy();
            }

            @Override
            public long getMaxEnergy() {
                return ((MatrixMultiblockData)((TileEntityInductionCasing)GuiMatrixStats.this.tile).getMultiblock()).getStorageCap();
            }
        }, GaugeType.STANDARD, (IGuiWrapper)this, 6, 13));
        this.addRenderableWidget(new GuiVerticalRateBar(this, new GuiBar.IBarInfoHandler(){

            @Override
            public Component getTooltip() {
                return MekanismLang.MATRIX_RECEIVING_RATE.translate(EnergyDisplay.of(((MatrixMultiblockData)((TileEntityInductionCasing)GuiMatrixStats.this.tile).getMultiblock()).getLastInput()));
            }

            @Override
            public double getLevel() {
                MatrixMultiblockData multiblock = (MatrixMultiblockData)((TileEntityInductionCasing)GuiMatrixStats.this.tile).getMultiblock();
                return multiblock.isFormed() ? MathUtils.divideToLevel(multiblock.getLastInput(), multiblock.getTransferCap()) : 0.0;
            }
        }, 30, 13));
        this.addRenderableWidget(new GuiVerticalRateBar(this, new GuiBar.IBarInfoHandler(){

            @Override
            public Component getTooltip() {
                return MekanismLang.MATRIX_OUTPUTTING_RATE.translate(EnergyDisplay.of(((MatrixMultiblockData)((TileEntityInductionCasing)GuiMatrixStats.this.tile).getMultiblock()).getLastOutput()));
            }

            @Override
            public double getLevel() {
                MatrixMultiblockData multiblock = (MatrixMultiblockData)((TileEntityInductionCasing)GuiMatrixStats.this.tile).getMultiblock();
                if (!multiblock.isFormed()) {
                    return 0.0;
                }
                return MathUtils.divideToLevel(multiblock.getLastOutput(), multiblock.getTransferCap());
            }
        }, 38, 13));
        this.addRenderableWidget(new GuiEnergyTab(this, () -> {
            MatrixMultiblockData multiblock = (MatrixMultiblockData)((TileEntityInductionCasing)this.tile).getMultiblock();
            return List.of(MekanismLang.STORING.translate(EnergyDisplay.of(multiblock.getEnergy(), multiblock.getStorageCap())), MekanismLang.MATRIX_INPUT_RATE.translate(EnergyDisplay.of(multiblock.getLastInput())), MekanismLang.MATRIX_OUTPUT_RATE.translate(EnergyDisplay.of(multiblock.getLastOutput())));
        }));
    }

    @Override
    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderTitleText(guiGraphics);
        MatrixMultiblockData multiblock = (MatrixMultiblockData)((TileEntityInductionCasing)this.tile).getMultiblock();
        this.drawScrollingString(guiGraphics, (Component)MekanismLang.INPUT.translate(), 45, 26, IFancyFontRenderer.TextAlignment.LEFT, this.subheadingTextColor(), this.getXSize() - 54, 8, false);
        this.drawScrollingString(guiGraphics, EnergyDisplay.of(multiblock.getLastInput(), multiblock.getTransferCap()).getTextComponent(), 51, 35, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), this.getXSize() - 60, 8, false);
        this.drawScrollingString(guiGraphics, (Component)MekanismLang.OUTPUT.translate(), 45, 46, IFancyFontRenderer.TextAlignment.LEFT, this.subheadingTextColor(), this.getXSize() - 54, 8, false);
        this.drawScrollingString(guiGraphics, EnergyDisplay.of(multiblock.getLastOutput(), multiblock.getTransferCap()).getTextComponent(), 51, 55, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), this.getXSize() - 60, 8, false);
        this.drawScrollingString(guiGraphics, (Component)MekanismLang.MATRIX_DIMENSIONS.translate(), 0, 82, IFancyFontRenderer.TextAlignment.LEFT, this.subheadingTextColor(), 8, false);
        if (multiblock.isFormed()) {
            this.drawScrollingString(guiGraphics, (Component)MekanismLang.MATRIX_DIMENSION_REPRESENTATION.translate(multiblock.width(), multiblock.height(), multiblock.length()), 6, 91, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), this.getXSize() - 6, 8, false);
        }
        this.drawScrollingString(guiGraphics, (Component)MekanismLang.MATRIX_CONSTITUENTS.translate(), 0, 102, IFancyFontRenderer.TextAlignment.LEFT, this.subheadingTextColor(), 8, false);
        this.drawScrollingString(guiGraphics, (Component)MekanismLang.MATRIX_CELLS.translate(multiblock.getCellCount()), 6, 111, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), this.getXSize() - 6, 8, false);
        this.drawScrollingString(guiGraphics, (Component)MekanismLang.MATRIX_PROVIDERS.translate(multiblock.getProviderCount()), 6, 120, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), this.getXSize() - 6, 8, false);
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }
}

