/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.BooleanSupplier;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiSideHolder;
import mekanism.common.inventory.warning.ISupportsWarning;
import mekanism.common.inventory.warning.WarningTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GuiInsetElement<DATA_SOURCE>
extends GuiSideHolder
implements ISupportsWarning<GuiInsetElement<DATA_SOURCE>> {
    protected final int border;
    protected final int innerWidth;
    protected final int innerHeight;
    protected final DATA_SOURCE dataSource;
    protected final ResourceLocation overlay;
    @Nullable
    protected BooleanSupplier warningSupplier;

    public GuiInsetElement(ResourceLocation overlay, IGuiWrapper gui, DATA_SOURCE dataSource, int x, int y, int height, int innerSize, boolean left) {
        super(gui, x, y, height, left, false);
        this.overlay = overlay;
        this.dataSource = dataSource;
        this.innerWidth = innerSize;
        this.innerHeight = innerSize;
        this.border = (this.width - this.innerWidth) / 2;
        this.clickSound = BUTTON_CLICK_SOUND;
        this.active = true;
    }

    @Override
    public GuiInsetElement<DATA_SOURCE> warning(@NotNull WarningTracker.WarningType type, @NotNull BooleanSupplier warningSupplier) {
        this.warningSupplier = ISupportsWarning.compound(this.warningSupplier, this.gui().trackWarning(type, warningSupplier));
        return this;
    }

    @Override
    public boolean isMouseOver(double xAxis, double yAxis) {
        return this.active && this.visible && xAxis >= (double)(this.getX() + this.border) && xAxis < (double)(this.getRight() - this.border) && yAxis >= (double)(this.getY() + this.border) && yAxis < (double)(this.getBottom() - this.border);
    }

    @Override
    protected int getButtonX() {
        return super.getButtonX() + this.border + (this.left ? 1 : -1);
    }

    @Override
    protected int getButtonY() {
        return super.getButtonY() + this.border;
    }

    @Override
    protected int getButtonWidth() {
        return this.innerWidth;
    }

    @Override
    protected int getButtonHeight() {
        return this.innerHeight;
    }

    protected ResourceLocation getOverlay() {
        return this.overlay;
    }

    @Override
    protected void draw(@NotNull GuiGraphics guiGraphics) {
        boolean warning;
        boolean bl = warning = this.warningSupplier != null && this.warningSupplier.getAsBoolean();
        if (warning) {
            this.drawUncolored(guiGraphics);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            guiGraphics.blit(WARNING_TEXTURE, this.relativeX, this.relativeY, 0.0f, 0.0f, this.width, this.height, 256, 256);
            RenderSystem.disableBlend();
        } else {
            super.draw(guiGraphics);
        }
    }

    @Override
    public void drawBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.buttonBackground != GuiElement.ButtonBackground.NONE) {
            this.drawButton(guiGraphics, mouseX, mouseY);
        }
        this.drawBackgroundOverlay(guiGraphics);
    }

    protected void drawBackgroundOverlay(@NotNull GuiGraphics guiGraphics) {
        guiGraphics.blit(this.getOverlay(), this.getButtonX(), this.getButtonY(), 0.0f, 0.0f, this.innerWidth, this.innerHeight, this.innerWidth, this.innerHeight);
    }
}

