/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.jei;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.window.GuiWindow;
import mekanism.client.recipe_viewer.GuiElementHandler;
import mekanism.client.recipe_viewer.interfaces.IRecipeViewerRecipeArea;
import mekanism.client.recipe_viewer.jei.MekanismJEI;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.runtime.IClickableIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;

public class JeiGuiElementHandler
implements IGuiContainerHandler<GuiMekanism<?>> {
    private final IIngredientManager ingredientManager;

    public JeiGuiElementHandler(IIngredientManager ingredientManager) {
        this.ingredientManager = ingredientManager;
    }

    public List<Rect2i> getGuiExtraAreas(GuiMekanism<?> gui) {
        return GuiElementHandler.getGuiExtraAreas(gui);
    }

    public Optional<IClickableIngredient<?>> getClickableIngredientUnderMouse(GuiMekanism<?> gui, double mouseX, double mouseY) {
        return GuiElementHandler.getClickableIngredientUnderMouse(gui, mouseX, mouseY, (helper, ingredient) -> this.ingredientManager.createClickableIngredient(ingredient, helper.getIngredientBounds(mouseX, mouseY), false).orElse(null));
    }

    public Collection<IGuiClickableArea> getGuiClickableAreas(GuiMekanism<?> gui, double mouseX, double mouseY) {
        GuiWindow guiWindow = gui.getWindowHovering(mouseX += (double)gui.getGuiLeft(), mouseY += (double)gui.getGuiTop());
        if (guiWindow == null) {
            return this.getGuiClickableArea(gui.children(), mouseX, mouseY);
        }
        return this.getGuiClickableArea(guiWindow.children(), mouseX, mouseY);
    }

    private Collection<IGuiClickableArea> getGuiClickableArea(List<? extends GuiEventListener> children, double mouseX, double mouseY) {
        for (GuiEventListener guiEventListener : children) {
            IRecipeViewerRecipeType<?>[] categories;
            IRecipeViewerRecipeArea recipeArea;
            if (!(guiEventListener instanceof ContainerEventHandler)) continue;
            ContainerEventHandler eventHandler = (ContainerEventHandler)guiEventListener;
            Collection<IGuiClickableArea> clickableGrandChildAreas = this.getGuiClickableArea(eventHandler.children(), mouseX, mouseY);
            if (!clickableGrandChildAreas.isEmpty()) {
                return clickableGrandChildAreas;
            }
            if (!(guiEventListener instanceof IRecipeViewerRecipeArea) || !(recipeArea = (IRecipeViewerRecipeArea)guiEventListener).isRecipeViewerAreaActive() || !(guiEventListener instanceof GuiElement)) continue;
            GuiElement element = (GuiElement)guiEventListener;
            if (!element.visible || (categories = recipeArea.getRecipeCategories()) == null || !recipeArea.isMouseOverRecipeViewerArea(mouseX, mouseY)) continue;
            IGuiClickableArea clickableArea = IGuiClickableArea.createBasic((int)element.getRelativeX(), (int)element.getRelativeY(), (int)element.getWidth(), (int)element.getHeight(), MekanismJEI.recipeType(categories));
            return Collections.singleton(clickableArea);
        }
        return Collections.emptyList();
    }
}

