/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.transmitter;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.text.EnumColor;
import mekanism.client.model.ModelTransporterBox;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.RenderResizableCuboid;
import mekanism.client.render.transmitter.RenderTransmitterBase;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.network.transmitter.DiversionTransporter;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.tile.transmitter.TileEntityDiversionTransporter;
import mekanism.common.tile.transmitter.TileEntityLogisticalTransporterBase;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class RenderLogisticalTransporter
extends RenderTransmitterBase<TileEntityLogisticalTransporterBase> {
    private static final Map<Direction, MekanismRenderer.Model3D> cachedOverlays = new EnumMap<Direction, MekanismRenderer.Model3D>(Direction.class);
    private static final int DIVERSION_OVERLAY_ARGB = MekanismRenderer.getColorARGB(0xFFFFFF, 0.8f);
    @Nullable
    private static TextureAtlasSprite gunpowderIcon;
    @Nullable
    private static TextureAtlasSprite torchOffIcon;
    @Nullable
    private static TextureAtlasSprite torchOnIcon;
    private final ModelTransporterBox modelBox;
    private final LazyItemRenderer itemRenderer = new LazyItemRenderer();

    public RenderLogisticalTransporter(BlockEntityRendererProvider.Context context) {
        super(context);
        this.modelBox = new ModelTransporterBox(context.getModelSet());
    }

    public static void onStitch(TextureAtlas map) {
        cachedOverlays.clear();
        gunpowderIcon = map.getSprite(ResourceLocation.withDefaultNamespace((String)"item/gunpowder"));
        torchOffIcon = map.getSprite(ResourceLocation.withDefaultNamespace((String)"block/redstone_torch_off"));
        torchOnIcon = map.getSprite(ResourceLocation.withDefaultNamespace((String)"block/redstone_torch"));
    }

    @Override
    protected void render(TileEntityLogisticalTransporterBase tile, float partialTick, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight, ProfilerFiller profiler) {
        Collection<TransporterStack> inTransit;
        LogisticalTransporterBase transporter = tile.getTransmitter();
        BlockPos pos = tile.getBlockPos();
        if (!MekanismConfig.client.opaqueTransmitters.get() && !(inTransit = transporter.getTransit()).isEmpty()) {
            matrix.pushPose();
            this.itemRenderer.init(tile.getLevel(), pos);
            float partial = partialTick * (float)transporter.tier.getSpeed();
            Collection<TransporterStack> reducedTransit = this.getReducedTransit(inTransit);
            for (TransporterStack stack : reducedTransit) {
                float[] stackPos = TransporterUtils.getStackPosition(transporter, stack, partial);
                matrix.pushPose();
                matrix.translate(stackPos[0], stackPos[1], stackPos[2]);
                matrix.scale(0.75f, 0.75f, 0.75f);
                this.itemRenderer.renderAsStack(matrix, renderer, stack.itemStack, light);
                matrix.popPose();
                if (stack.color == null) continue;
                this.modelBox.render(matrix, renderer, overlayLight, stackPos[0], stackPos[1], stackPos[2], stack.color);
            }
            matrix.popPose();
        }
        if (transporter instanceof DiversionTransporter) {
            BlockHitResult rayTraceResult;
            ItemStack itemStack;
            DiversionTransporter diversionTransporter = (DiversionTransporter)transporter;
            LocalPlayer player = Minecraft.getInstance().player;
            ItemStack itemStack2 = itemStack = player == null ? ItemStack.EMPTY : player.getMainHandItem();
            if (!itemStack.isEmpty() && itemStack.getItem() instanceof ItemConfigurator && (rayTraceResult = MekanismUtils.rayTrace((Player)player)).getType() != HitResult.Type.MISS && rayTraceResult.getBlockPos().equals((Object)pos)) {
                Direction side = tile.getSideLookingAt((Player)player, rayTraceResult.getDirection());
                matrix.pushPose();
                matrix.scale(0.5f, 0.5f, 0.5f);
                matrix.translate(0.5, 0.5, 0.5);
                RenderResizableCuboid.renderCube(this.getOverlayModel(diversionTransporter, side), matrix, renderer.getBuffer(Sheets.translucentCullBlockSheet()), DIVERSION_OVERLAY_ARGB, 0xF000F0, overlayLight, RenderResizableCuboid.FaceDisplay.FRONT, this.getCamera(), null);
                matrix.popPose();
            }
        }
    }

    @Override
    protected String getProfilerSection() {
        return "logisticalTransporter";
    }

    @Override
    protected boolean shouldRenderTransmitter(TileEntityLogisticalTransporterBase tile, Vec3 camera) {
        return super.shouldRenderTransmitter(tile, camera) || tile instanceof TileEntityDiversionTransporter;
    }

    private Collection<TransporterStack> getReducedTransit(Collection<TransporterStack> inTransit) {
        ArrayList<TransporterStack> reducedTransit = new ArrayList<TransporterStack>();
        ObjectOpenHashSet information = new ObjectOpenHashSet();
        for (TransporterStack stack : inTransit) {
            if (stack == null || stack.itemStack.isEmpty() || !information.add(new TransportInformation(stack))) continue;
            reducedTransit.add(stack);
        }
        return reducedTransit;
    }

    private MekanismRenderer.Model3D getOverlayModel(DiversionTransporter transporter, Direction side) {
        MekanismRenderer.Model3D model = cachedOverlays.computeIfAbsent(side, face -> {
            MekanismRenderer.Model3D model3D = new MekanismRenderer.Model3D().prepSingleFaceModelSize((Direction)face);
            for (Direction direction : EnumUtils.DIRECTIONS) {
                model3D.setSideRender(direction, direction == face);
            }
            return model3D;
        });
        return model.setTexture(side, switch (transporter.modes[side.ordinal()]) {
            default -> throw new MatchException(null, null);
            case DiversionTransporter.DiversionControl.DISABLED -> gunpowderIcon;
            case DiversionTransporter.DiversionControl.HIGH -> torchOnIcon;
            case DiversionTransporter.DiversionControl.LOW -> torchOffIcon;
        });
    }

    private static class LazyItemRenderer {
        @Nullable
        private ItemEntity entityItem;
        @Nullable
        private EntityRenderer<? super ItemEntity> renderer;

        private LazyItemRenderer() {
        }

        public void init(Level world, BlockPos pos) {
            if (this.entityItem == null) {
                this.entityItem = new ItemEntity(EntityType.ITEM, world);
            } else {
                this.entityItem.setLevel(world);
            }
            this.entityItem.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
            this.entityItem.age = 0;
        }

        private void renderAsStack(PoseStack matrix, MultiBufferSource buffer, ItemStack stack, int light) {
            if (this.entityItem != null) {
                if (this.renderer == null) {
                    this.renderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)this.entityItem);
                }
                this.entityItem.setItem(stack);
                this.renderer.render((Entity)this.entityItem, 0.0f, 0.0f, matrix, buffer, light);
            }
        }
    }

    private static class TransportInformation {
        @Nullable
        private final EnumColor color;
        private final HashedItem item;
        private final int progress;

        private TransportInformation(TransporterStack transporterStack) {
            this.progress = transporterStack.progress;
            this.color = transporterStack.color;
            this.item = HashedItem.create(transporterStack.itemStack);
        }

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.progress;
            code = 31 * code + this.item.hashCode();
            if (this.color != null) {
                code = 31 * code + this.color.hashCode();
            }
            return code;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof TransportInformation)) return false;
            TransportInformation other = (TransportInformation)obj;
            if (this.progress != other.progress) return false;
            if (this.color != other.color) return false;
            if (!this.item.equals(other.item)) return false;
            return true;
        }
    }
}

