/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.sound;

import mekanism.client.sound.PlayerSound;
import mekanism.common.item.gear.ItemFlamethrower;
import mekanism.common.registries.MekanismSounds;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class FlamethrowerSoundIdle
extends PlayerSound {
    public FlamethrowerSoundIdle(@NotNull Player player) {
        super(player, MekanismSounds.FLAMETHROWER_IDLE);
    }

    @Override
    public boolean shouldPlaySound(@NotNull Player player) {
        if (player.isUsingItem()) {
            InteractionHand usedHand = player.getUsedItemHand();
            if (player.getItemInHand(usedHand).getItem() instanceof ItemFlamethrower) {
                return false;
            }
            return ItemFlamethrower.isIdleFlamethrower(player, usedHand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
        }
        return ItemFlamethrower.isIdleFlamethrower(player, InteractionHand.MAIN_HAND) || ItemFlamethrower.isIdleFlamethrower(player, InteractionHand.OFF_HAND);
    }
}

