/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.entity.ai;

import mekanism.common.entity.EntityRobit;
import mekanism.common.entity.ai.RobitAIBase;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class RobitAIFollow
extends RobitAIBase {
    private Player theOwner;
    private final float maxDist;
    private final float minDist;

    public RobitAIFollow(EntityRobit entityRobit, float speed, float min, float max) {
        super(entityRobit, speed);
        this.minDist = min;
        this.maxDist = max;
    }

    public boolean canUse() {
        Player player = this.theRobit.getOwner();
        if (player == null || player.isSpectator()) {
            return false;
        }
        if (this.theRobit.level().dimension() != player.level().dimension()) {
            return false;
        }
        if (!this.theRobit.getFollowing()) {
            this.theRobit.getLookControl().setLookAt((Entity)player, 6.0f, (float)this.theRobit.getMaxHeadXRot() / 10.0f);
            return false;
        }
        if (this.theRobit.distanceToSqr((Entity)player) < (double)(this.minDist * this.minDist)) {
            return false;
        }
        if (this.theRobit.getEnergyContainer().isEmpty()) {
            return false;
        }
        this.theOwner = player;
        return true;
    }

    public boolean canContinueToUse() {
        return !this.getNavigator().isDone() && this.theRobit.distanceToSqr((Entity)this.theOwner) > (double)(this.maxDist * this.maxDist) && this.theRobit.getFollowing() && !this.theRobit.getEnergyContainer().isEmpty() && this.theOwner.level().dimension() == this.theRobit.level().dimension();
    }

    @Override
    public void stop() {
        this.theOwner = null;
        super.stop();
    }

    public void tick() {
        if (this.theRobit.getFollowing()) {
            this.updateTask((Entity)this.theOwner);
        }
    }
}

