/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.bracket;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotation.BracketResolver;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import mekanism.api.MekanismAPI;
import mekanism.api.gear.ModuleData;
import mekanism.api.robit.RobitSkin;
import mekanism.common.integration.crafttweaker.chemical.CrTChemical;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.api.BracketHandlers")
public class CrTBracketHandlers {
    @ZenCodeType.Method
    @BracketResolver(value="chemical")
    public static ICrTChemicalStack getChemicalStack(String tokens) {
        return CrTChemical.makeStack(CrTBracketHandlers.getValue("chemical", tokens, MekanismAPI.CHEMICAL_REGISTRY_NAME), 1L);
    }

    @ZenCodeType.Method
    @BracketResolver(value="robit_skin")
    public static RobitSkin getRobitSkin(String tokens) {
        return CrTBracketHandlers.getValue("robit_skin", tokens, MekanismAPI.ROBIT_SKIN_REGISTRY_NAME);
    }

    @ZenCodeType.Method
    @BracketResolver(value="module_data")
    public static ModuleData<?> getModuleData(String tokens) {
        return CrTBracketHandlers.getValue("module_data", tokens, MekanismAPI.MODULE_REGISTRY_NAME);
    }

    private static <V> V getValue(String bracket, String tokens, ResourceKey<? extends Registry<? extends V>> registryKey) {
        ResourceLocation registryName = ResourceLocation.tryParse((String)tokens);
        if (registryName == null) {
            String typeName = bracket.replace("_", " ");
            throw new IllegalArgumentException("Could not get " + typeName + " for <" + bracket + ":" + tokens + ">. Syntax is <" + bracket + ":modid:" + bracket + "_name>");
        }
        Registry registry = CraftTweakerAPI.getAccessibleElementsProvider().registryAccess().registryOrThrow(registryKey);
        if (registry.containsKey(registryName)) {
            return (V)registry.get(registryName);
        }
        String typeName = bracket.replace("_", " ");
        throw new IllegalArgumentException("Could not get " + typeName + " for <" + bracket + ":" + tokens + ">, " + typeName + " does not appear to exist!");
    }
}

