/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.content;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.zencode.scriptrun.ScriptRunConfiguration;
import java.util.HashMap;
import java.util.Map;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.common.integration.crafttweaker.CrTConstants;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.registries.RegisterEvent;

public class CrTContentUtils {
    private static Map<ResourceLocation, Chemical> queuedChemicals = new HashMap<ResourceLocation, Chemical>();

    public static void queueChemicalForRegistration(ResourceLocation registryName, Chemical chemical) {
        if (queuedChemicals != null) {
            if (queuedChemicals.put(registryName, chemical) == null) {
                CrTConstants.CRT_LOGGER.info("Queueing Chemical '{}' for registration.", (Object)registryName);
            } else {
                CrTConstants.CRT_LOGGER.warn("Registration for Chemical '{}' is already queued, skipping duplicate.", (Object)registryName);
            }
        }
    }

    public static void registerCrTContent(RegisterEvent event) {
        event.register(MekanismAPI.CHEMICAL_REGISTRY_NAME, helper -> {
            try {
                CraftTweakerAPI.getScriptRunManager().createScriptRun(new ScriptRunConfiguration("mekanismcontent", CrTConstants.CONTENT_LOADER_SOURCE_ID, ScriptRunConfiguration.RunKind.EXECUTE)).execute();
            }
            catch (Throwable e) {
                CrTConstants.CRT_LOGGER.error("Unable to register chemicals due to an error.", e);
            }
            if (queuedChemicals != null) {
                int count = queuedChemicals.size();
                CrTConstants.CRT_LOGGER.info("Registering {} custom {}.", (Object)count, (Object)(count == 1 ? "chemical" : "chemicals"));
                for (Map.Entry<ResourceLocation, Chemical> entry : queuedChemicals.entrySet()) {
                    ResourceLocation registryName = entry.getKey();
                    helper.register(registryName, (Object)entry.getValue());
                    CrTConstants.CRT_LOGGER.info("Registered Chemical: '{}'.", (Object)registryName);
                }
                queuedChemicals = null;
            }
        });
    }
}

