/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe.manager;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.CTFluidIngredient;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.FluidChemicalToChemicalRecipe;
import mekanism.api.recipes.basic.BasicWashingRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.vanilla_input.SingleFluidChemicalRecipeInput;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.integration.crafttweaker.recipe.manager.MekanismRecipeManager;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.recipe.manager.FluidChemicalToChemical")
public abstract class FluidChemicalToChemicalRecipeManager
extends MekanismRecipeManager<SingleFluidChemicalRecipeInput, FluidChemicalToChemicalRecipe> {
    protected FluidChemicalToChemicalRecipeManager(IMekanismRecipeTypeProvider<SingleFluidChemicalRecipeInput, FluidChemicalToChemicalRecipe, ?> recipeType) {
        super(recipeType);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, CTFluidIngredient fluidInput, ChemicalStackIngredient chemicalInput, ICrTChemicalStack output) {
        this.addRecipe(name, this.makeRecipe(fluidInput, chemicalInput, output));
    }

    public final FluidChemicalToChemicalRecipe makeRecipe(CTFluidIngredient fluidInput, ChemicalStackIngredient chemicalInput, ICrTChemicalStack output) {
        return this.makeRecipe(fluidInput, chemicalInput, this.getAndValidateNotEmpty(output));
    }

    protected abstract FluidChemicalToChemicalRecipe makeRecipe(CTFluidIngredient var1, ChemicalStackIngredient var2, ChemicalStack var3);

    @Override
    protected String describeOutputs(FluidChemicalToChemicalRecipe recipe) {
        return CrTUtils.describeOutputs(recipe.getOutputDefinition());
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.recipe.manager.FluidChemicalToChemical.Washing")
    public static class ChemicalWasherRecipeManager
    extends FluidChemicalToChemicalRecipeManager {
        public static final ChemicalWasherRecipeManager INSTANCE = new ChemicalWasherRecipeManager();

        private ChemicalWasherRecipeManager() {
            super((IMekanismRecipeTypeProvider<SingleFluidChemicalRecipeInput, FluidChemicalToChemicalRecipe, ?>)MekanismRecipeType.WASHING);
        }

        @Override
        protected FluidChemicalToChemicalRecipe makeRecipe(CTFluidIngredient fluidInput, ChemicalStackIngredient chemicalInput, ChemicalStack output) {
            return new BasicWashingRecipe(CrTUtils.fromCrT(fluidInput), chemicalInput, output);
        }
    }
}

