/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.entity.robit;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import mekanism.api.MekanismAPI;
import mekanism.api.robit.RobitSkin;
import mekanism.common.entity.EntityRobit;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.entity.robit.RobitContainer;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.list.SyncableResourceKeyList;
import mekanism.common.registries.MekanismContainerTypes;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Inventory;

public class MainRobitContainer
extends RobitContainer
implements MekanismContainer.ISpecificContainerTracker {
    private List<ResourceKey<RobitSkin>> unlockedSkins = Collections.emptyList();

    public MainRobitContainer(int id, Inventory inv, EntityRobit robit) {
        super(MekanismContainerTypes.MAIN_ROBIT, id, inv, robit);
    }

    public List<ResourceKey<RobitSkin>> getUnlockedSkins() {
        return this.unlockedSkins;
    }

    @Override
    public List<ISyncableData> getSpecificSyncableData() {
        SyncableResourceKeyList<RobitSkin> data;
        if (this.getLevel().isClientSide()) {
            data = SyncableResourceKeyList.create(MekanismAPI.ROBIT_SKIN_REGISTRY_NAME, () -> this.unlockedSkins, value -> {
                this.unlockedSkins = value;
            });
        } else {
            Registry registry = this.getLevel().registryAccess().registryOrThrow(MekanismAPI.ROBIT_SKIN_REGISTRY_NAME);
            data = SyncableResourceKeyList.create(MekanismAPI.ROBIT_SKIN_REGISTRY_NAME, () -> registry.entrySet().stream().filter(entry -> ((RobitSkin)entry.getValue()).isUnlocked(this.inv.player)).map(Map.Entry::getKey).toList(), value -> {
                this.unlockedSkins = value;
            });
        }
        return Collections.singletonList(data);
    }
}

