/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.slot;

import java.util.Optional;
import java.util.function.Consumer;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.slot.IInsertableSlot;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.inventory.warning.ISupportsWarning;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryContainerSlot
extends Slot
implements IInsertableSlot {
    private static final Container emptyInventory = new SimpleContainer(0);
    private final Consumer<ItemStack> uncheckedSetter;
    private final ContainerSlotType slotType;
    private final BasicInventorySlot slot;
    @Nullable
    private final SlotOverlay slotOverlay;
    @Nullable
    private final Consumer<ISupportsWarning<?>> warningAdder;

    public InventoryContainerSlot(BasicInventorySlot slot, int x, int y, ContainerSlotType slotType, @Nullable SlotOverlay slotOverlay, @Nullable Consumer<ISupportsWarning<?>> warningAdder, Consumer<ItemStack> uncheckedSetter) {
        super(emptyInventory, 0, x, y);
        this.slot = slot;
        this.slotType = slotType;
        this.slotOverlay = slotOverlay;
        this.warningAdder = warningAdder;
        this.uncheckedSetter = uncheckedSetter;
    }

    public IInventorySlot getInventorySlot() {
        return this.slot;
    }

    public void addWarnings(ISupportsWarning<?> slot) {
        if (this.warningAdder != null) {
            this.warningAdder.accept(slot);
        }
    }

    @Override
    @NotNull
    public ItemStack insertItem(@NotNull ItemStack stack, Action action) {
        ItemStack remainder = this.slot.insertItem(stack, action, AutomationType.MANUAL);
        if (action.execute() && stack.getCount() != remainder.getCount()) {
            this.setChanged();
        }
        return remainder;
    }

    public boolean mayPlace(@NotNull ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        if (this.slot.isEmpty()) {
            return this.insertItem(stack, Action.SIMULATE).getCount() < stack.getCount();
        }
        if (this.slot.extractItem(1, Action.SIMULATE, AutomationType.MANUAL).isEmpty()) {
            return false;
        }
        return this.slot.isItemValidForInsertion(stack, AutomationType.MANUAL);
    }

    protected boolean allowPartialRemoval() {
        return true;
    }

    @NotNull
    public ItemStack getItem() {
        return this.slot.getStack();
    }

    public boolean hasItem() {
        return !this.slot.isEmpty();
    }

    public void set(@NotNull ItemStack stack) {
        this.uncheckedSetter.accept(stack);
        this.setChanged();
    }

    public void setChanged() {
        super.setChanged();
        this.slot.onContentsChanged();
    }

    public int getMaxStackSize() {
        return this.slot.getLimit(ItemStack.EMPTY);
    }

    public int getMaxStackSize(@NotNull ItemStack stack) {
        return this.slot.getLimit(stack);
    }

    public boolean mayPickup(@NotNull Player player) {
        return !this.slot.extractItem(1, Action.SIMULATE, AutomationType.MANUAL).isEmpty();
    }

    @NotNull
    public ItemStack remove(int amount) {
        return this.slot.extractItem(amount, Action.EXECUTE, AutomationType.MANUAL);
    }

    public ContainerSlotType getSlotType() {
        return this.slotType;
    }

    @Nullable
    public SlotOverlay getSlotOverlay() {
        return this.slotOverlay;
    }

    @NotNull
    public Optional<ItemStack> tryRemove(int count, int decrement, @NotNull Player player) {
        if (this.allowPartialRemoval()) {
            if (!this.mayPickup(player)) {
                return Optional.empty();
            }
            ItemStack itemstack = this.remove(count = Math.min(count, decrement));
            if (itemstack.isEmpty()) {
                return Optional.empty();
            }
            if (this.getItem().isEmpty()) {
                this.setByPlayer(ItemStack.EMPTY, itemstack);
            }
            return Optional.of(itemstack);
        }
        return super.tryRemove(count, decrement, player);
    }
}

