/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.slot;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.functions.ConstantPredicates;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.inventory.slot.IFluidHandlerSlot;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class FluidInventorySlot
extends BasicInventorySlot
implements IFluidHandlerSlot {
    protected final IExtendedFluidTank fluidTank;
    private boolean isDraining;
    private boolean isFilling;

    public static FluidInventorySlot input(IExtendedFluidTank fluidTank, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(fluidTank, "Fluid tank cannot be null");
        return new FluidInventorySlot(fluidTank, ConstantPredicates.alwaysFalse(), FluidInventorySlot.getInputPredicate(fluidTank), listener, x, y);
    }

    protected static Predicate<ItemStack> getInputPredicate(IExtendedFluidTank fluidTank) {
        return stack -> {
            IFluidHandlerItem fluidHandlerItem = FluidInventorySlot.tryGetFluidHandlerUnstacked(stack);
            if (fluidHandlerItem != null) {
                boolean hasEmpty = false;
                int tanks = fluidHandlerItem.getTanks();
                for (int tank = 0; tank < tanks; ++tank) {
                    FluidStack fluidInTank = fluidHandlerItem.getFluidInTank(tank);
                    if (fluidInTank.isEmpty()) {
                        hasEmpty = true;
                        continue;
                    }
                    if (fluidTank.insert(fluidInTank, Action.SIMULATE, AutomationType.INTERNAL).getAmount() >= fluidInTank.getAmount()) continue;
                    return true;
                }
                if (fluidTank.isEmpty()) {
                    return hasEmpty;
                }
                FluidStack fluid = fluidTank.getFluid();
                fluid = fluid.getAmount() < 1000 ? fluid.copyWithAmount(1000) : fluid.copy();
                return fluidHandlerItem.fill(fluid, IFluidHandler.FluidAction.SIMULATE) > 0;
            }
            return false;
        };
    }

    public static FluidInventorySlot rotary(IExtendedFluidTank fluidTank, BooleanSupplier modeSupplier, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(fluidTank, "Fluid tank cannot be null");
        Objects.requireNonNull(modeSupplier, "Mode supplier cannot be null");
        return new FluidInventorySlot(fluidTank, ConstantPredicates.alwaysFalse(), stack -> {
            IFluidHandlerItem fluidHandlerItem = Capabilities.FLUID.getCapability((ItemStack)stack);
            if (fluidHandlerItem != null) {
                boolean mode = modeSupplier.getAsBoolean();
                boolean allEmpty = true;
                int tanks = fluidHandlerItem.getTanks();
                for (int tank = 0; tank < tanks; ++tank) {
                    FluidStack fluidInTank = fluidHandlerItem.getFluidInTank(tank);
                    if (fluidInTank.isEmpty()) continue;
                    if (fluidTank.insert(fluidInTank, Action.SIMULATE, AutomationType.INTERNAL).getAmount() < fluidInTank.getAmount()) {
                        return mode;
                    }
                    allEmpty = false;
                }
                return allEmpty && !mode;
            }
            return false;
        }, listener, x, y);
    }

    public static FluidInventorySlot fill(IExtendedFluidTank fluidTank, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(fluidTank, "Fluid tank cannot be null");
        return new FluidInventorySlot(fluidTank, ConstantPredicates.alwaysFalse(), FluidInventorySlot.getFillPredicate(fluidTank), listener, x, y);
    }

    public static Predicate<ItemStack> getFillPredicate(IExtendedFluidTank fluidTank) {
        return stack -> {
            IFluidHandlerItem fluidHandlerItem = Capabilities.FLUID.getCapability((ItemStack)stack);
            if (fluidHandlerItem != null) {
                int tanks = fluidHandlerItem.getTanks();
                for (int tank = 0; tank < tanks; ++tank) {
                    FluidStack fluidInTank = fluidHandlerItem.getFluidInTank(tank);
                    if (fluidInTank.isEmpty() || fluidTank.insert(fluidInTank, Action.SIMULATE, AutomationType.INTERNAL).getAmount() >= fluidInTank.getAmount()) continue;
                    return true;
                }
            }
            return false;
        };
    }

    public static FluidInventorySlot drain(IExtendedFluidTank fluidTank, @Nullable IContentsListener listener, int x, int y) {
        Objects.requireNonNull(fluidTank, "Fluid handler cannot be null");
        return new FluidInventorySlot(fluidTank, ConstantPredicates.alwaysFalse(), stack -> {
            IFluidHandlerItem itemFluidHandler = FluidInventorySlot.tryGetFluidHandlerUnstacked(stack);
            if (itemFluidHandler != null) {
                FluidStack fluidInTank = fluidTank.getFluid();
                if (fluidInTank.isEmpty()) {
                    return FluidInventorySlot.isNonFullFluidContainer(itemFluidHandler);
                }
                return itemFluidHandler.fill(fluidInTank.copy(), IFluidHandler.FluidAction.SIMULATE) > 0;
            }
            return false;
        }, listener, x, y);
    }

    @Nullable
    public static IFluidHandlerItem tryGetFluidHandlerUnstacked(ItemStack stack) {
        if (stack.getCount() > 1 && Capabilities.FLUID.getCapability(stack) == null) {
            return null;
        }
        ItemStack stackToCheck = stack.getCount() > 1 ? stack.copyWithCount(1) : stack;
        return Capabilities.FLUID.getCapability(stackToCheck);
    }

    public static boolean isNonFullFluidContainer(@Nullable IFluidHandlerItem fluidHandler) {
        if (fluidHandler != null) {
            int tanks = fluidHandler.getTanks();
            for (int tank = 0; tank < tanks; ++tank) {
                if (fluidHandler.getFluidInTank(tank).getAmount() >= fluidHandler.getTankCapacity(tank)) continue;
                return true;
            }
        }
        return false;
    }

    protected FluidInventorySlot(IExtendedFluidTank fluidTank, Predicate<@NotNull ItemStack> canExtract, Predicate<@NotNull ItemStack> canInsert, @Nullable IContentsListener listener, int x, int y) {
        this(fluidTank, canExtract, canInsert, ConstantPredicates.alwaysTrue(), listener, x, y);
    }

    protected FluidInventorySlot(IExtendedFluidTank fluidTank, Predicate<@NotNull ItemStack> canExtract, Predicate<@NotNull ItemStack> canInsert, Predicate<@NotNull ItemStack> validator, @Nullable IContentsListener listener, int x, int y) {
        super(canExtract, canInsert, validator, listener, x, y);
        this.setSlotType(ContainerSlotType.EXTRA);
        this.fluidTank = fluidTank;
    }

    @Override
    public void setStack(ItemStack stack) {
        super.setStack(stack);
        this.isDraining = false;
        this.isFilling = false;
    }

    @Override
    public IExtendedFluidTank getFluidTank() {
        return this.fluidTank;
    }

    @Override
    public boolean isDraining() {
        return this.isDraining;
    }

    @Override
    public boolean isFilling() {
        return this.isFilling;
    }

    @Override
    public void setDraining(boolean draining) {
        this.isDraining = draining;
    }

    @Override
    public void setFilling(boolean filling) {
        this.isFilling = filling;
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = super.serializeNBT(provider);
        if (this.isDraining) {
            nbt.putBoolean("draining", true);
        }
        if (this.isFilling) {
            nbt.putBoolean("filling", true);
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.isDraining = nbt.getBoolean("draining");
        this.isFilling = nbt.getBoolean("filling");
        super.deserializeNBT(provider, nbt);
    }
}

