/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import mekanism.api.IAlloyInteraction;
import mekanism.api.tier.IAlloyTier;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ItemAlloy
extends Item {
    private final IAlloyTier tier;

    public ItemAlloy(IAlloyTier tier, Item.Properties properties) {
        super(properties);
        this.tier = tier;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos;
        Level world;
        IAlloyInteraction alloyInteraction;
        Player player = context.getPlayer();
        if (player != null && MekanismConfig.general.transmitterAlloyUpgrade.get() && (alloyInteraction = WorldUtils.getCapability(world = context.getLevel(), Capabilities.ALLOY_INTERACTION, pos = context.getClickedPos(), context.getClickedFace())) != null) {
            if (!world.isClientSide) {
                alloyInteraction.onAlloyInteraction(player, context.getItemInHand(), this.tier);
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public IAlloyTier getTier() {
        return this.tier;
    }
}

