/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.interfaces;

import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.IMekanismChemicalHandler;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.util.ChemicalUtil;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public interface IChemicalItem {
    @NotNull
    default public ChemicalStack useChemical(ItemStack stack, long amount) {
        IChemicalHandler chemicalHandlerItem = (IChemicalHandler)Capabilities.CHEMICAL.getCapability(stack);
        if (chemicalHandlerItem != null) {
            IMekanismChemicalHandler chemicalHandler;
            IChemicalTank chemicalTank;
            if (chemicalHandlerItem instanceof IMekanismChemicalHandler && (chemicalTank = (chemicalHandler = (IMekanismChemicalHandler)chemicalHandlerItem).getChemicalTank(0, null)) != null) {
                return chemicalTank.extract(amount, Action.EXECUTE, AutomationType.MANUAL);
            }
            return chemicalHandlerItem.extractChemical(amount, Action.EXECUTE);
        }
        return ChemicalStack.EMPTY;
    }

    default public boolean hasChemical(ItemStack stack) {
        return ChemicalUtil.hasAnyChemical(stack);
    }
}

