/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.math;

import mekanism.common.lib.math.voxel.VoxelCuboid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;

public record Plane(Vec3 minPos, Vec3 maxPos) {
    public static Plane getInnerCuboidPlane(VoxelCuboid cuboid, VoxelCuboid.CuboidSide side) {
        int minX = cuboid.getMinPos().getX() + 1;
        int minY = cuboid.getMinPos().getY() + 1;
        int minZ = cuboid.getMinPos().getZ() + 1;
        int maxX = cuboid.getMaxPos().getX();
        int maxY = cuboid.getMaxPos().getY();
        int maxZ = cuboid.getMaxPos().getZ();
        return switch (side) {
            default -> throw new MatchException(null, null);
            case VoxelCuboid.CuboidSide.NORTH -> new Plane(new Vec3((double)minX, (double)minY, (double)minZ), new Vec3((double)maxX, (double)maxY, (double)minZ));
            case VoxelCuboid.CuboidSide.SOUTH -> new Plane(new Vec3((double)minX, (double)minY, (double)maxZ), new Vec3((double)maxX, (double)maxY, (double)maxZ));
            case VoxelCuboid.CuboidSide.WEST -> new Plane(new Vec3((double)minX, (double)minY, (double)minZ), new Vec3((double)minX, (double)maxY, (double)maxZ));
            case VoxelCuboid.CuboidSide.EAST -> new Plane(new Vec3((double)maxX, (double)minY, (double)minZ), new Vec3((double)maxX, (double)maxY, (double)maxZ));
            case VoxelCuboid.CuboidSide.BOTTOM -> new Plane(new Vec3((double)minX, (double)minY, (double)minZ), new Vec3((double)maxX, (double)minY, (double)maxZ));
            case VoxelCuboid.CuboidSide.TOP -> new Plane(new Vec3((double)minX, (double)maxY, (double)minZ), new Vec3((double)maxX, (double)maxY, (double)maxZ));
        };
    }

    public Vec3 getRandomPoint(RandomSource rand) {
        return new Vec3(this.minPos.x + rand.nextDouble() * (this.maxPos.x - this.minPos.x), this.minPos.y + rand.nextDouble() * (this.maxPos.y - this.minPos.y), this.minPos.z + rand.nextDouble() * (this.maxPos.z - this.minPos.z));
    }
}

