/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.radiation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.IntSupplier;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.config.MekanismConfig;
import mekanism.common.config.listener.ConfigBasedCachedIntSupplier;
import mekanism.common.lib.collection.IndexedCuboidMap;
import mekanism.common.lib.radiation.LevelAndMaxMagnitude;
import mekanism.common.lib.radiation.RadiationManager;
import mekanism.common.lib.radiation.RadiationSource;
import mekanism.common.lib.radiation.RadiationUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.ListTag;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class RadiationLevelData
implements INBTSerializable<ListTag> {
    private static final IntSupplier MAX_BLOCK_RANGE = new ConfigBasedCachedIntSupplier(() -> {
        int chunkRadius = MekanismConfig.general.radiationChunkCheckRadius.get();
        return Mth.square((int)(chunkRadius * 16));
    }, MekanismConfig.general.radiationChunkCheckRadius);
    private final IndexedCuboidMap<RadiationSource> sources = new IndexedCuboidMap();

    public LevelAndMaxMagnitude getRadiationLevelAndMaxMagnitude(BlockPos checkPos) {
        double level;
        if (this.isEmpty()) {
            return LevelAndMaxMagnitude.BASELINE;
        }
        double maxMagnitude = level = RadiationManager.get().baselineRadiation();
        Iterator<RadiationSource> sourceIterator = this.sources.find(checkPos);
        while (sourceIterator.hasNext()) {
            RadiationSource source = sourceIterator.next();
            level += RadiationUtil.computeExposure(source, checkPos);
            maxMagnitude = Math.max(maxMagnitude, source.getMagnitude());
        }
        if (level <= LevelAndMaxMagnitude.BASELINE.level() && maxMagnitude <= LevelAndMaxMagnitude.BASELINE.maxMagnitude()) {
            return LevelAndMaxMagnitude.BASELINE;
        }
        return new LevelAndMaxMagnitude(level, maxMagnitude);
    }

    public void radiate(BlockPos pos, double magnitude) {
        RadiationSource src = this.sources.findFirstAt(pos);
        if (src == null) {
            this.addNew(new RadiationSource(pos, magnitude));
        } else {
            src.radiate(magnitude);
        }
    }

    private void addNew(RadiationSource value) {
        this.sources.track(value, value.getPosition(), MAX_BLOCK_RANGE.getAsInt());
    }

    public boolean removeRadiationSources(int chunkX, int chunkZ) {
        if (this.isEmpty()) {
            return false;
        }
        ArrayList<RadiationSource> toRemove = new ArrayList<RadiationSource>();
        Iterator<RadiationSource> centredInChunk = this.sources.allCenteredInChunk(chunkX, chunkZ);
        while (centredInChunk.hasNext()) {
            toRemove.add(centredInChunk.next());
        }
        for (RadiationSource radiationSource : toRemove) {
            this.sources.remove(radiationSource);
        }
        return !toRemove.isEmpty();
    }

    public boolean removeRadiationSource(BlockPos pos) {
        return this.sources.removeAt(pos);
    }

    public boolean isEmpty() {
        return this.sources.isEmpty();
    }

    public void decay() {
        this.sources.removeIf(RadiationSource::decay);
    }

    public void clearAll() {
        this.sources.clear();
    }

    @Deprecated(forRemoval=true, since="10.7.15")
    public Collection<RadiationSource> values() {
        return this.sources.values();
    }

    public Iterator<RadiationSource> getSources(int chunkX, int chunkZ) {
        return this.sources.allCenteredInChunk(chunkX, chunkZ);
    }

    @Nullable
    public ListTag serializeNBT(HolderLookup.Provider provider) {
        if (this.isEmpty()) {
            return null;
        }
        ListTag tag = new ListTag(this.sources.values().size());
        for (RadiationSource value : this.sources.values()) {
            tag.add((Object)value.serializeNBT());
        }
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, ListTag nbt) {
        for (int i = 0; i < nbt.size(); ++i) {
            RadiationSource src = RadiationSource.deserializeNBT(nbt.getCompound(i));
            if (src == null) continue;
            this.addNew(src);
        }
    }
}

