/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.transmitter;

import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.function.IntFunction;
import mekanism.api.IIncrementalEnum;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.IHasTranslationKey;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;

@NothingNullByDefault
public enum ConnectionType implements IIncrementalEnum<ConnectionType>,
StringRepresentable,
IHasTranslationKey,
IHasTextComponent.IHasEnumNameTextComponent
{
    NORMAL(MekanismLang.CONNECTION_NORMAL, EnumColor.ORANGE),
    PUSH(MekanismLang.CONNECTION_PUSH, EnumColor.BRIGHT_GREEN),
    PULL(MekanismLang.CONNECTION_PULL, EnumColor.YELLOW),
    NONE(MekanismLang.CONNECTION_NONE, EnumColor.WHITE);

    public static final IntFunction<ConnectionType> BY_ID;
    public static final StreamCodec<ByteBuf, ConnectionType> STREAM_CODEC;
    private final ILangEntry langEntry;
    private final EnumColor color;

    private ConnectionType(ILangEntry langEntry, EnumColor color) {
        this.langEntry = langEntry;
        this.color = color;
    }

    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    @Override
    public Component getTextComponent() {
        return this.langEntry.translateColored(this.color);
    }

    @Override
    public String getTranslationKey() {
        return this.langEntry.getTranslationKey();
    }

    @Override
    public ConnectionType byIndex(int index) {
        return BY_ID.apply(index);
    }

    public boolean canAccept() {
        return this == NORMAL || this == PULL;
    }

    public boolean canSendTo() {
        return this == NORMAL || this == PUSH;
    }

    static {
        BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])ConnectionType.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
    }
}

