/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe;

import java.util.Map;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.registries.MekanismRecipeSerializersInternal;
import mekanism.common.tags.MekanismTags;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

@NothingNullByDefault
public class ClearConfigurationRecipe
extends CustomRecipe {
    public ClearConfigurationRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput input, Level level) {
        ItemStack target = this.getTargetStack(input);
        if (target.isEmpty()) {
            return false;
        }
        for (Map.Entry entry : target.getComponentsPatch().entrySet()) {
            if (!BuiltInRegistries.DATA_COMPONENT_TYPE.wrapAsHolder((Object)((DataComponentType)entry.getKey())).is(MekanismTags.DataComponents.CLEARABLE_CONFIG)) continue;
            return true;
        }
        return false;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider provider) {
        ItemStack target = this.getTargetStack(input);
        if (target.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack output = target.copyWithCount(1);
        DataComponentMap prototype = output.getPrototype();
        for (Map.Entry entry : output.getComponentsPatch().entrySet()) {
            DataComponentType component = (DataComponentType)entry.getKey();
            Holder componentHolder = BuiltInRegistries.DATA_COMPONENT_TYPE.wrapAsHolder((Object)component);
            if (!componentHolder.is(MekanismTags.DataComponents.CLEARABLE_CONFIG)) continue;
            this.resetComponent(output, prototype, component);
        }
        return output;
    }

    private <TYPE> void resetComponent(ItemStack output, DataComponentMap prototype, DataComponentType<TYPE> componentType) {
        if (prototype.has(componentType)) {
            output.set(componentType, prototype.get(componentType));
        } else {
            output.remove(componentType);
        }
    }

    private ItemStack getTargetStack(CraftingInput input) {
        ItemStack target = ItemStack.EMPTY;
        int slots = input.size();
        for (int i = 0; i < slots; ++i) {
            ItemStack stackInSlot = input.getItem(i);
            if (stackInSlot.isEmpty()) continue;
            if (stackInSlot.isComponentsPatchEmpty()) {
                return ItemStack.EMPTY;
            }
            if (!target.isEmpty()) {
                return ItemStack.EMPTY;
            }
            target = stackInSlot;
        }
        return target;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height > 0;
    }

    public boolean isIncomplete() {
        return false;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)MekanismRecipeSerializersInternal.CLEAR_CONFIGURATION.get();
    }
}

