/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.multiblock;

import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.content.tank.TankMultiblockData;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.multiblock.TileEntityDynamicTank;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class TileEntityDynamicValve
extends TileEntityDynamicTank {
    public TileEntityDynamicValve(BlockPos pos, BlockState state) {
        super((Holder<Block>)MekanismBlocks.DYNAMIC_VALVE, pos, state);
    }

    @Override
    @NotNull
    protected IFluidTankHolder getInitialFluidTanks(IContentsListener listener) {
        return side -> ((TankMultiblockData)this.getMultiblock()).getFluidTanks(side);
    }

    @Override
    @NotNull
    public IChemicalTankHolder getInitialChemicalTanks(IContentsListener listener) {
        return side -> ((TankMultiblockData)this.getMultiblock()).getChemicalTanks(side);
    }

    @Override
    public boolean persists(ContainerType<?, ?, ?> type) {
        if (type == ContainerType.FLUID || type == ContainerType.CHEMICAL) {
            return false;
        }
        return super.persists(type);
    }

    @Override
    @NotNull
    public FluidStack insertFluid(int tank, @NotNull FluidStack stack, Direction side, @NotNull Action action) {
        return this.handleValves(stack, action, super.insertFluid(tank, stack, side, action));
    }

    @Override
    @NotNull
    public FluidStack insertFluid(@NotNull FluidStack stack, Direction side, @NotNull Action action) {
        return this.handleValves(stack, action, super.insertFluid(stack, side, action));
    }

    private FluidStack handleValves(@NotNull FluidStack stack, @NotNull Action action, @NotNull FluidStack remainder) {
        if (action.execute() && remainder.getAmount() < stack.getAmount()) {
            ((TankMultiblockData)this.getMultiblock()).triggerValveTransfer(this);
        }
        return remainder;
    }

    @Override
    public int getRedstoneLevel() {
        return ((TankMultiblockData)this.getMultiblock()).getCurrentRedstoneLevel();
    }
}

