/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.prefab;

import java.util.Objects;
import java.util.UUID;
import mekanism.common.lib.multiblock.IInternalMultiblock;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityInternalMultiblock
extends TileEntityMekanism
implements IInternalMultiblock {
    @Nullable
    private MultiblockData multiblock;
    private UUID multiblockUUID;

    public TileEntityInternalMultiblock(Holder<Block> blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
    }

    @Override
    public void setMultiblock(@Nullable MultiblockData multiblock) {
        this.multiblock = multiblock;
        this.setMultiblock(multiblock == null ? null : multiblock.inventoryID);
    }

    private void setMultiblock(UUID id) {
        UUID old = this.multiblockUUID;
        this.multiblockUUID = id;
        if (!Objects.equals(old, id)) {
            this.multiblockChanged(old);
        }
    }

    protected void multiblockChanged(@Nullable UUID old) {
        if (!this.isRemote()) {
            this.sendUpdatePacket();
        }
    }

    @Override
    @Nullable
    public UUID getMultiblockUUID() {
        return this.multiblockUUID;
    }

    @Override
    @Nullable
    public MultiblockData getMultiblock() {
        return this.multiblock;
    }

    @Override
    public void onNeighborChange(Block block, BlockPos neighborPos) {
        super.onNeighborChange(block, neighborPos);
        if (!this.isRemote() && this.multiblock != null) {
            int dZ;
            int dY;
            int dX = Math.abs(neighborPos.getX() - this.worldPosition.getX());
            if (dX + (dY = Math.abs(neighborPos.getY() - this.worldPosition.getY())) + (dZ = Math.abs(neighborPos.getZ() - this.worldPosition.getZ())) > 1) {
                return;
            }
            if (this.level.isEmptyBlock(neighborPos) || !this.multiblock.isKnownLocation(neighborPos)) {
                this.multiblock.recheckStructure = true;
            }
        }
    }

    @Override
    public void blockRemoved() {
        super.blockRemoved();
        if (!this.isRemote() && this.hasFormedMultiblock() && this.multiblock != null) {
            this.multiblock.recheckStructure = true;
        }
    }

    @Override
    @NotNull
    public CompoundTag getReducedUpdateTag(@NotNull HolderLookup.Provider provider) {
        CompoundTag updateTag = super.getReducedUpdateTag(provider);
        if (this.multiblockUUID != null) {
            updateTag.putUUID("inventory_id", this.multiblockUUID);
        }
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
        NBTUtils.setUUIDIfPresentElse(tag, "inventory_id", this::setMultiblock, () -> {
            this.multiblockUUID = null;
        });
    }
}

