/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.common.registries;

import java.util.List;
import java.util.Map;
import mekanism.additions.common.entity.EntityBalloon;
import mekanism.additions.common.entity.EntityObsidianTNT;
import mekanism.additions.common.entity.baby.EntityBabyBogged;
import mekanism.additions.common.entity.baby.EntityBabyCreeper;
import mekanism.additions.common.entity.baby.EntityBabyEnderman;
import mekanism.additions.common.entity.baby.EntityBabySkeleton;
import mekanism.additions.common.entity.baby.EntityBabyStray;
import mekanism.additions.common.entity.baby.EntityBabyWitherSkeleton;
import mekanism.common.registration.MekanismDeferredHolder;
import mekanism.common.registration.impl.EntityTypeDeferredRegister;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Bogged;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;

public class AdditionsEntityTypes {
    private static final AttributeModifier BABY_SPEED_NERF_MODIFIER = new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"baby"), -0.5, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    private static final AttributeModifier BABY_HEALTH_NERF_MODIFIER = new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"baby_health"), -0.5, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    private static final AttributeModifier BABY_ATTACK_NERF_MODIFIER = new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"baby_attack"), -0.75, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    public static final EntityTypeDeferredRegister ENTITY_TYPES = new EntityTypeDeferredRegister("mekanismadditions");
    public static final MekanismDeferredHolder<EntityType<?>, EntityType<EntityBabyBogged>> BABY_BOGGED = ENTITY_TYPES.registerBasicMonster("baby_bogged", () -> AdditionsEntityTypes.baby(EntityBabyBogged::new, EntityType.BOGGED), Bogged::createAttributes);
    public static final MekanismDeferredHolder<EntityType<?>, EntityType<EntityBabyCreeper>> BABY_CREEPER = ENTITY_TYPES.registerBasicMonster("baby_creeper", () -> AdditionsEntityTypes.baby(EntityBabyCreeper::new, EntityType.CREEPER, 0.625f), Creeper::createAttributes);
    public static final MekanismDeferredHolder<EntityType<?>, EntityType<EntityBabyEnderman>> BABY_ENDERMAN = ENTITY_TYPES.registerBasicMonster("baby_enderman", () -> AdditionsEntityTypes.baby(EntityBabyEnderman::new, EntityType.ENDERMAN, 0.525f), EnderMan::createAttributes);
    public static final MekanismDeferredHolder<EntityType<?>, EntityType<EntityBabySkeleton>> BABY_SKELETON = ENTITY_TYPES.registerBasicMonster("baby_skeleton", () -> AdditionsEntityTypes.baby(EntityBabySkeleton::new, EntityType.SKELETON), AbstractSkeleton::createAttributes);
    public static final MekanismDeferredHolder<EntityType<?>, EntityType<EntityBabyStray>> BABY_STRAY = ENTITY_TYPES.registerBasicPlacement("baby_stray", () -> AdditionsEntityTypes.baby(EntityBabyStray::new, EntityType.STRAY), AbstractSkeleton::createAttributes, EntityBabyStray::spawnRestrictions);
    public static final MekanismDeferredHolder<EntityType<?>, EntityType<EntityBabyWitherSkeleton>> BABY_WITHER_SKELETON = ENTITY_TYPES.registerBasicMonster("baby_wither_skeleton", () -> AdditionsEntityTypes.baby(EntityBabyWitherSkeleton::new, EntityType.WITHER_SKELETON), AbstractSkeleton::createAttributes);
    public static final MekanismDeferredHolder<EntityType<?>, EntityType<EntityBalloon>> BALLOON = ENTITY_TYPES.registerBuilder("balloon", () -> EntityType.Builder.of(EntityBalloon::new, (MobCategory)MobCategory.MISC).sized(0.4f, 0.45f).eyeHeight(0.725f));
    public static final MekanismDeferredHolder<EntityType<?>, EntityType<EntityObsidianTNT>> OBSIDIAN_TNT = ENTITY_TYPES.registerBuilder("obsidian_tnt", () -> EntityType.Builder.of(EntityObsidianTNT::new, (MobCategory)MobCategory.MISC).fireImmune().sized(0.98f, 0.98f).eyeHeight(0.15f).clientTrackingRange(10).updateInterval(10));

    private AdditionsEntityTypes() {
    }

    public static void setupBabyModifiers(LivingEntity entity) {
        if (!entity.level().isClientSide) {
            AttributeInstance attributeInstance = entity.getAttribute(Attributes.MOVEMENT_SPEED);
            if (attributeInstance != null) {
                attributeInstance.addPermanentModifier(BABY_SPEED_NERF_MODIFIER);
            }
            if ((attributeInstance = entity.getAttribute(Attributes.MAX_HEALTH)) != null) {
                attributeInstance.addPermanentModifier(BABY_HEALTH_NERF_MODIFIER);
            }
            if ((attributeInstance = entity.getAttribute(Attributes.ATTACK_DAMAGE)) != null) {
                attributeInstance.addPermanentModifier(BABY_ATTACK_NERF_MODIFIER);
            }
        }
    }

    private static <ENTITY extends Entity> EntityType.Builder<ENTITY> baby(EntityType.EntityFactory<ENTITY> factory, EntityType<?> parent) {
        return AdditionsEntityTypes.baby(factory, parent, 0.5625f);
    }

    private static <ENTITY extends Entity> EntityType.Builder<ENTITY> baby(EntityType.EntityFactory<ENTITY> factory, EntityType<?> parent, float scale) {
        EntityType.Builder builder = EntityType.Builder.of(factory, (MobCategory)parent.getCategory());
        if (!parent.canSerialize()) {
            builder.noSave();
        }
        if (!parent.canSummon()) {
            builder.noSummon();
        }
        if (parent.fireImmune()) {
            builder.fireImmune();
        }
        if (parent.canSpawnFarFromPlayer()) {
            builder.canSpawnFarFromPlayer();
        }
        builder.immuneTo((Block[])parent.immuneTo.toArray(Block[]::new)).setShouldReceiveVelocityUpdates(parent.trackDeltas()).clientTrackingRange(parent.clientTrackingRange()).setTrackingRange(parent.clientTrackingRange()).updateInterval(parent.updateInterval()).setUpdateInterval(parent.updateInterval());
        EntityDimensions babyDimensions = parent.getDimensions().scale(scale);
        builder.sized(babyDimensions.width(), babyDimensions.height());
        builder.eyeHeight(babyDimensions.height() * 0.83f);
        for (Map.Entry entry : babyDimensions.attachments().attachments.entrySet()) {
            EntityAttachment attachment = (EntityAttachment)entry.getKey();
            for (Vec3 vec3 : (List)entry.getValue()) {
                builder.attach(attachment, vec3);
            }
        }
        return builder;
    }
}

