/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.common.voice;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import mekanism.additions.common.MekanismAdditions;
import mekanism.additions.common.item.ItemWalkieTalkie;
import mekanism.additions.common.registries.AdditionsDataComponents;
import mekanism.additions.common.voice.VoiceServerManager;
import mekanism.common.Mekanism;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class VoiceConnection
extends Thread {
    private final MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
    private DataOutputStream output;
    private DataInputStream input;
    private boolean open = true;
    private final Socket socket;
    private UUID uuid;

    VoiceConnection(Socket s) {
        super("VoiceServer Connection Thread");
        this.socket = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block11: {
            try {
                this.input = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
                this.output = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
                if (MekanismAdditions.voiceManager == null) break block11;
                VoiceServerManager voiceServerManager = MekanismAdditions.voiceManager;
                synchronized (voiceServerManager) {
                    int retryCount = 0;
                    while (this.uuid == null && retryCount <= 100) {
                        try {
                            List<ServerPlayer> players = Collections.synchronizedList(new ArrayList(this.server.getPlayerList().getPlayers()));
                            for (ServerPlayer player : players) {
                                String playerIP = player.getIpAddress();
                                if (!this.server.isDedicatedServer() && playerIP.equals("local") && !MekanismAdditions.voiceManager.isFoundLocal()) {
                                    MekanismAdditions.voiceManager.setFoundLocal(true);
                                    this.uuid = player.getUUID();
                                    break;
                                }
                                if (!playerIP.equals(this.socket.getInetAddress().getHostAddress())) continue;
                                this.uuid = player.getUUID();
                                break;
                            }
                            ++retryCount;
                            VoiceConnection.sleep(50L);
                        }
                        catch (Exception exception) {}
                    }
                    if (this.uuid == null) {
                        Mekanism.logger.error("VoiceServer: Unable to trace connection's IP address.");
                        this.kill();
                        return;
                    }
                    Mekanism.logger.info("VoiceServer: Traced IP for {} in {} attempts.", (Object)this.uuid, (Object)retryCount);
                }
            }
            catch (Exception e) {
                Mekanism.logger.error("VoiceServer: Error while starting server-based connection.", (Throwable)e);
                this.open = false;
            }
        }
        new Thread(() -> {
            while (this.open) {
                try {
                    short byteCount = this.input.readShort();
                    byte[] audioData = new byte[byteCount];
                    this.input.readFully(audioData);
                    if (byteCount <= 0) continue;
                    MekanismAdditions.voiceManager.sendToPlayers(byteCount, audioData, this);
                }
                catch (Exception e) {
                    this.open = false;
                }
            }
            this.kill();
        }, "Voice Server Client Listen Thread").start();
    }

    private void kill() {
        try {
            if (this.input != null) {
                this.input.close();
            }
            if (this.output != null) {
                this.output.close();
            }
            if (this.socket != null) {
                this.socket.close();
            }
            MekanismAdditions.voiceManager.removeConnection(this);
        }
        catch (Exception e) {
            Mekanism.logger.error("VoiceServer: Error while stopping server-based connection.", (Throwable)e);
        }
    }

    public void sendToPlayer(short byteCount, byte[] audioData, VoiceConnection connection) {
        if (!this.open) {
            this.kill();
        }
        try {
            this.output.writeShort(byteCount);
            this.output.write(audioData);
            this.output.flush();
        }
        catch (Exception e) {
            Mekanism.logger.error("VoiceServer: Error while sending data to player.", (Throwable)e);
        }
    }

    public boolean canListen(int channel) {
        ServerPlayer player = this.getPlayer();
        for (ItemStack itemStack : player.getInventory().items) {
            if (!this.canListen(channel, itemStack)) continue;
            return true;
        }
        return this.canListen(channel, player.getOffhandItem());
    }

    private boolean canListen(int channel, ItemStack stack) {
        ItemWalkieTalkie.WalkieData data = (ItemWalkieTalkie.WalkieData)stack.getOrDefault(AdditionsDataComponents.WALKIE_DATA, (Object)ItemWalkieTalkie.WalkieData.DEFAULT);
        return data.running() && data.channel() == channel;
    }

    public int getCurrentChannel() {
        ServerPlayer player = this.getPlayer();
        int channel = this.getCurrentChannel(player.getMainHandItem());
        if (channel == 0) {
            channel = this.getCurrentChannel(player.getOffhandItem());
        }
        return channel;
    }

    private int getCurrentChannel(ItemStack stack) {
        ItemWalkieTalkie.WalkieData data = (ItemWalkieTalkie.WalkieData)stack.getOrDefault(AdditionsDataComponents.WALKIE_DATA, (Object)ItemWalkieTalkie.WalkieData.DEFAULT);
        return data.running() ? data.channel() : 0;
    }

    public ServerPlayer getPlayer() {
        return this.server.getPlayerList().getPlayer(this.uuid);
    }
}

