/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.common.world.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import mekanism.additions.common.config.AdditionsConfig;
import mekanism.additions.common.config.MekanismAdditionsConfig;
import mekanism.additions.common.entity.baby.BabyType;
import mekanism.additions.common.registries.AdditionsBiomeModifierSerializers;
import mekanism.common.Mekanism;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.MobSpawnSettingsBuilder;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;

public record BabyEntitySpawnBiomeModifier(BabyType babyType, AdditionsConfig.SpawnConfig spawnConfig) implements BiomeModifier
{
    public BabyEntitySpawnBiomeModifier(BabyType babyType) {
        this(babyType, MekanismAdditionsConfig.additions.getConfig(babyType));
    }

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.REMOVE && this.spawnConfig.shouldSpawn.get() && !biome.is(this.babyType.biomeBlacklist)) {
            MobSpawnSettingsBuilder mobSpawnSettings = builder.getMobSpawnSettings();
            List monsterSpawns = mobSpawnSettings.getSpawner(MobCategory.MONSTER);
            for (MobSpawnSettings.SpawnerData spawner : this.spawnConfig.getSpawnersToAdd(monsterSpawns)) {
                mobSpawnSettings.addSpawn(MobCategory.MONSTER, spawner);
                MobSpawnSettings.MobSpawnCost parentCost = mobSpawnSettings.getCost(this.spawnConfig.parentType);
                if (parentCost == null) {
                    Mekanism.logger.debug("Adding spawn rate for '{}' in biome '{}', with weight: {}, minSize: {}, maxSize: {}", new Object[]{Util.getRegisteredName((Registry)BuiltInRegistries.ENTITY_TYPE, (Object)spawner.type), biome.getRegisteredName(), spawner.getWeight(), spawner.minCount, spawner.maxCount});
                    continue;
                }
                double spawnCostPerEntity = parentCost.charge() * this.spawnConfig.spawnCostPerEntityPercentage.get();
                double maxSpawnCost = parentCost.energyBudget() * this.spawnConfig.maxSpawnCostPercentage.get();
                mobSpawnSettings.addMobCharge(spawner.type, spawnCostPerEntity, maxSpawnCost);
                Mekanism.logger.debug("Adding spawn rate for '{}' in biome '{}', with weight: {}, minSize: {}, maxSize: {}, spawnCostPerEntity: {}, maxSpawnCost: {}", new Object[]{Util.getRegisteredName((Registry)BuiltInRegistries.ENTITY_TYPE, (Object)spawner.type), biome.getRegisteredName(), spawner.getWeight(), spawner.minCount, spawner.maxCount, spawnCostPerEntity, maxSpawnCost});
            }
        }
    }

    public MapCodec<? extends BiomeModifier> codec() {
        return (MapCodec)AdditionsBiomeModifierSerializers.SPAWN_BABIES.get();
    }

    public static MapCodec<BabyEntitySpawnBiomeModifier> makeCodec() {
        return RecordCodecBuilder.mapCodec(builder -> builder.group((App)BabyType.CODEC.fieldOf("baby_type").forGetter(BabyEntitySpawnBiomeModifier::babyType)).apply((Applicative)builder, BabyEntitySpawnBiomeModifier::new));
    }
}

